/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import org.drools.compiler.PackageBuilder;
import org.drools.jsr94.rules.RuleEngineTestBase;
import org.drools.rule.Package;

public class LocalRuleExecutionSetProviderTest
extends RuleEngineTestBase {
    private RuleAdministrator ruleAdministrator;
    private LocalRuleExecutionSetProvider ruleSetProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.ruleAdministrator = this.ruleServiceProvider.getRuleAdministrator();
        this.ruleSetProvider = this.ruleAdministrator.getLocalRuleExecutionSetProvider(null);
    }

    public void testCreateFromInputStream() throws Exception {
        InputStream rulesStream = RuleEngineTestBase.class.getResourceAsStream(this.bindUri);
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet(rulesStream, null);
        LocalRuleExecutionSetProviderTest.assertEquals((String)"rule set name", (String)"SistersRules", (String)ruleSet.getName());
        LocalRuleExecutionSetProviderTest.assertEquals((String)"number of rules", (int)1, (int)ruleSet.getRules().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateFromObject() throws Exception {
        InputStream inputStream = null;
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri)));
            Package pkg = builder.getPackage();
            RuleExecutionSet ruleExecutionSet = this.ruleSetProvider.createRuleExecutionSet((Object)pkg, null);
            LocalRuleExecutionSetProviderTest.assertEquals((String)"rule set name", (String)"SistersRules", (String)ruleExecutionSet.getName());
            LocalRuleExecutionSetProviderTest.assertEquals((String)"number of rules", (int)1, (int)ruleExecutionSet.getRules().size());
        }
        catch (IOException e) {
            LocalRuleExecutionSetProviderTest.fail((String)"Couldn't create the RuleExecutionSet. Test threw an IOException.");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void testCreateFromReader() throws Exception {
        InputStreamReader ruleReader = new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri));
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, null);
        LocalRuleExecutionSetProviderTest.assertEquals((String)"rule set name", (String)"SistersRules", (String)ruleSet.getName());
        LocalRuleExecutionSetProviderTest.assertEquals((String)"number of rules", (int)1, (int)ruleSet.getRules().size());
    }
}

