/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.jsr94.tck;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.drools.jsr94.rules.Jsr94FactHandle;
import org.jcp.jsr94.tck.ApiSignatureTest;
import org.jcp.jsr94.tck.ClassLoaderTest;
import org.jcp.jsr94.tck.ConfigurationExceptionTest;
import org.jcp.jsr94.tck.HandleTest;
import org.jcp.jsr94.tck.InvalidHandleExceptionTest;
import org.jcp.jsr94.tck.InvalidRuleSessionExceptionTest;
import org.jcp.jsr94.tck.ObjectFilterTest;
import org.jcp.jsr94.tck.RuleExceptionTest;
import org.jcp.jsr94.tck.RuleExecutionExceptionTest;
import org.jcp.jsr94.tck.RuleExecutionSetMetadataTest;
import org.jcp.jsr94.tck.RuleExecutionSetNotFoundExceptionTest;
import org.jcp.jsr94.tck.RuleRuntimeTest;
import org.jcp.jsr94.tck.RuleServiceProviderManagerTest;
import org.jcp.jsr94.tck.RuleServiceProviderTest;
import org.jcp.jsr94.tck.RuleSessionCreateExceptionTest;
import org.jcp.jsr94.tck.RuleSessionTest;
import org.jcp.jsr94.tck.RuleSessionTypeUnsupportedExceptionTest;
import org.jcp.jsr94.tck.StatefulRuleSessionTest;
import org.jcp.jsr94.tck.StatelessRuleSessionTest;
import org.jcp.jsr94.tck.admin.LocalRuleExecutionSetProviderTest;
import org.jcp.jsr94.tck.admin.RuleAdministrationExceptionTest;
import org.jcp.jsr94.tck.admin.RuleAdministratorTest;
import org.jcp.jsr94.tck.admin.RuleExecutionSetCreateExceptionTest;
import org.jcp.jsr94.tck.admin.RuleExecutionSetDeregistrationExceptionTest;
import org.jcp.jsr94.tck.admin.RuleExecutionSetRegisterExceptionTest;
import org.jcp.jsr94.tck.admin.RuleExecutionSetTest;
import org.jcp.jsr94.tck.admin.RuleTest;

public class AllTests
extends TestSuite {
    public static Test suite() {
        AllTests.setTckConf();
        TestSuite suite = new TestSuite("JSR 94 Test Compatability Kit");
        suite.addTestSuite(ApiSignatureTest.class);
        suite.addTestSuite(ClassLoaderTest.class);
        suite.addTestSuite(ConfigurationExceptionTest.class);
        suite.addTestSuite(HandleTest.class);
        suite.addTestSuite(InvalidHandleExceptionTest.class);
        suite.addTestSuite(InvalidRuleSessionExceptionTest.class);
        suite.addTestSuite(ObjectFilterTest.class);
        suite.addTestSuite(RuleExceptionTest.class);
        suite.addTestSuite(RuleExecutionExceptionTest.class);
        suite.addTestSuite(RuleExecutionSetMetadataTest.class);
        suite.addTestSuite(RuleExecutionSetNotFoundExceptionTest.class);
        suite.addTestSuite(RuleRuntimeTest.class);
        suite.addTestSuite(RuleServiceProviderManagerTest.class);
        suite.addTestSuite(RuleServiceProviderTest.class);
        suite.addTestSuite(RuleSessionCreateExceptionTest.class);
        suite.addTestSuite(RuleSessionTest.class);
        suite.addTestSuite(RuleSessionTypeUnsupportedExceptionTest.class);
        suite.addTestSuite(StatefulRuleSessionTest.class);
        suite.addTestSuite(StatelessRuleSessionTest.class);
        suite.addTestSuite(LocalRuleExecutionSetProviderTest.class);
        suite.addTestSuite(RuleAdministrationExceptionTest.class);
        suite.addTestSuite(RuleAdministratorTest.class);
        suite.addTestSuite(RuleExecutionSetCreateExceptionTest.class);
        suite.addTestSuite(RuleExecutionSetRegisterExceptionTest.class);
        suite.addTestSuite(RuleExecutionSetTest.class);
        suite.addTestSuite(RuleExecutionSetDeregistrationExceptionTest.class);
        suite.addTestSuite(RuleTest.class);
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTckConf() {
        File jarFile = null;
        ZipOutputStream zos = null;
        File rootDirectory = null;
        try {
            jarFile = File.createTempFile("drools-jsr94", ".jar");
            URL url = Jsr94FactHandle.class.getResource("Jsr94FactHandle.class");
            rootDirectory = new File(url.getFile()).getParentFile().getParentFile().getParentFile().getParentFile();
            zos = new ZipOutputStream(new FileOutputStream(jarFile));
            AllTests.zipDir(rootDirectory, zos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {}
            }
        }
        String conf = "";
        conf = conf + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        conf = conf + "<tck-configuration>\n";
        conf = conf + "<test-factory>org.jcp.jsr94.tck.util.TestFactory</test-factory>\n";
        conf = conf + "<rule-service-provider>org.drools.jsr94.rules.RuleServiceProviderImpl</rule-service-provider>\n";
        conf = conf + "<rule-service-provider-jar-url>file://" + jarFile.getAbsolutePath() + "</rule-service-provider-jar-url>\n";
        URL url = AllTests.class.getResource("AllTests.class");
        String setLocation = new File(url.getFile()).getParentFile().getAbsolutePath().replaceAll("\\\\", "/");
        if (setLocation.charAt(1) == ':') {
            setLocation = setLocation.substring(2);
        }
        conf = conf + "<rule-execution-set-location>" + setLocation + "</rule-execution-set-location>\n";
        conf = conf + "</tck-configuration>";
        url = AllTests.class.getResource("tck.conf");
        File tckConf = new File(url.getFile());
        BufferedWriter buffWriter = null;
        try {
            FileWriter fileWriter = new FileWriter(tckConf);
            buffWriter = new BufferedWriter(fileWriter);
            buffWriter.write(conf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                buffWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.setProperty("jsr94.tck.configuration", tckConf.getParent());
    }

    public static void zipDir(File zipDir, ZipOutputStream zos) {
        try {
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            for (int i = 0; i < dirList.length; ++i) {
                File f = new File(zipDir, dirList[i]);
                if (f.isDirectory()) {
                    AllTests.zipDir(f, zos);
                    continue;
                }
                FileInputStream fis = new FileInputStream(f);
                ZipEntry anEntry = new ZipEntry(f.getPath());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

