/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.rules.ConfigurationException;
import javax.rules.ObjectFilter;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import org.drools.jsr94.rules.ExampleRuleEngineFacade;
import org.drools.jsr94.rules.Person;
import org.drools.jsr94.rules.RuleServiceProviderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class StatelessRuleSessionTest {
    private ExampleRuleEngineFacade sessionBuilder;
    private final String bindUri = "sisters.drl";
    private final String bindUri_drl = "sisters_expander.drl";
    private final String bindUri_dsl = "sisters_expander.dsl";
    private final String bindUri_globals = "sisters_globals.drl";

    @Before
    public void setUp() throws Exception {
        this.sessionBuilder = new ExampleRuleEngineFacade();
        this.sessionBuilder.addRuleExecutionSet(this.bindUri, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri));
        HashMap<String, String> map = new HashMap<String, String>();
        InputStreamReader reader = new InputStreamReader(StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_dsl));
        map.put("dsl", this.getDSLText(reader).toString());
        this.sessionBuilder.addRuleExecutionSet(this.bindUri_drl, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_drl), map);
        this.sessionBuilder.addRuleExecutionSet(this.bindUri_globals, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_globals));
    }

    private StringBuffer getDSLText(Reader reader) throws IOException {
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    @Test
    @Ignore
    public void testCreateRuleExecutionSetFromStreamWithXml() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("source", "xml");
            RuleServiceProviderManager.registerRuleServiceProvider((String)"http://drools.org/", RuleServiceProviderImpl.class);
            RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)"http://drools.org/");
            LocalRuleExecutionSetProvider localRuleExecutionSetProvider = ruleServiceProvider.getRuleAdministrator().getLocalRuleExecutionSetProvider(null);
        }
        catch (RemoteException e) {
            Assert.fail();
        }
        catch (ConfigurationException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    @Ignore
    public void testCreateRuleExecutionSetFromStreamReaderWithXml() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("source", "xml");
            RuleServiceProviderManager.registerRuleServiceProvider((String)"http://drools.org/", RuleServiceProviderImpl.class);
            RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)"http://drools.org/");
            LocalRuleExecutionSetProvider localRuleExecutionSetProvider = ruleServiceProvider.getRuleAdministrator().getLocalRuleExecutionSetProvider(null);
        }
        catch (RemoteException e) {
            Assert.fail();
        }
        catch (ConfigurationException e) {
            Assert.fail();
        }
    }

    @Test
    public void testExecuteRulesGlobals() throws Exception {
        HashMap<String, Vector> map = new HashMap<String, Vector>();
        Vector v = new Vector();
        map.put("vector", v);
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_globals, map);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        Assert.assertEquals((String)"incorrect size", (long)5L, (long)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        v = (Vector)map.get("vector");
        Assert.assertNotNull((String)"Global Vector null", (Object)v);
        this.assertContains(v, "rebecca and jeannie are sisters");
        this.assertContains(v, "jeannie and rebecca are sisters");
        Assert.assertEquals((String)"Vector v incorrect size", (long)2L, (long)v.size());
        statelessSession.release();
    }

    @Test
    public void testExecuteRules() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        Assert.assertEquals((String)"incorrect size", (long)5L, (long)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        statelessSession.release();
    }

    @Test
    @Ignore
    public void testExecuteRulesWithXml() throws Exception {
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
    }

    @Test
    @Ignore
    public void testExecuteRules_dsl() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_drl);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        Assert.assertEquals((String)"incorrect size", (long)5L, (long)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        statelessSession.release();
    }

    @Test
    public void testExecuteRulesWithFilter() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        List outList = statelessSession.executeRules(inObjects, (ObjectFilter)new PersonFilter());
        Assert.assertEquals((String)"incorrect size", (long)3L, (long)outList.size());
        Assert.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        Assert.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        Assert.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
    }

    @Test
    public void testExecuteRulesWithFilter_dsl() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_drl);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        List outList = statelessSession.executeRules(inObjects, (ObjectFilter)new PersonFilter());
        Assert.assertEquals((String)"incorrect size", (long)3L, (long)outList.size());
        Assert.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        Assert.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        Assert.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
    }

    protected void assertContains(List expected, Object object) {
        if (expected.contains(object)) {
            return;
        }
        Assert.fail((String)(object + " not in " + expected));
    }

    static class PersonFilter
    implements ObjectFilter {
        PersonFilter() {
        }

        public Object filter(Object object) {
            return object instanceof Person ? object : null;
        }

        public void reset() {
        }
    }
}

