/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.jsr94.rules.RuleEngineTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalRuleExecutionSetProviderTest
extends RuleEngineTestBase {
    private RuleAdministrator ruleAdministrator;
    private LocalRuleExecutionSetProvider ruleSetProvider;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ruleAdministrator = this.ruleServiceProvider.getRuleAdministrator();
        this.ruleSetProvider = this.ruleAdministrator.getLocalRuleExecutionSetProvider(null);
    }

    @Test
    public void testCreateFromInputStream() throws Exception {
        InputStream rulesStream = RuleEngineTestBase.class.getResourceAsStream(this.bindUri);
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet(rulesStream, null);
        Assert.assertEquals((String)"rule set name", (Object)"SistersRules", (Object)ruleSet.getName());
        Assert.assertEquals((String)"number of rules", (long)1L, (long)ruleSet.getRules().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFromObject() throws Exception {
        InputStream inputStream = null;
        try {
            KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
            builder.addPackageFromDrl((Reader)new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri)));
            InternalKnowledgePackage pkg = builder.getPackage();
            RuleExecutionSet ruleExecutionSet = this.ruleSetProvider.createRuleExecutionSet((Object)pkg, null);
            Assert.assertEquals((String)"rule set name", (Object)"SistersRules", (Object)ruleExecutionSet.getName());
            Assert.assertEquals((String)"number of rules", (long)1L, (long)ruleExecutionSet.getRules().size());
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't create the RuleExecutionSet. Test threw an IOException.");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testCreateFromReader() throws Exception {
        InputStreamReader ruleReader = new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri));
        RuleExecutionSet ruleSet = this.ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, null);
        Assert.assertEquals((String)"rule set name", (Object)"SistersRules", (Object)ruleSet.getName());
        Assert.assertEquals((String)"number of rules", (long)1L, (long)ruleSet.getRules().size());
    }
}

