/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetProvider;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.jsr94.rules.RuleEngineTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleExecutionSetProviderTest
extends RuleEngineTestBase {
    private RuleAdministrator ruleAdministrator;
    private RuleExecutionSetProvider ruleSetProvider;
    private InternalKnowledgePackage pkg;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ruleAdministrator = this.ruleServiceProvider.getRuleAdministrator();
        this.ruleSetProvider = this.ruleAdministrator.getRuleExecutionSetProvider(null);
        this.initPackage();
    }

    private void initPackage() {
        InputStream resourceAsStream = null;
        try {
            InternalKnowledgePackage pkg;
            KnowledgeBuilderImpl builder = new KnowledgeBuilderImpl();
            builder.addPackageFromDrl((Reader)new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri)));
            this.pkg = pkg = builder.getPackage();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("setUp() could not init the RuleSet due to an IOException in the InputStream: " + e);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("setUp() could not init the RuleSet, " + e);
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @After
    public void tearDown() {
        this.pkg = null;
    }

    @Test
    public void testCreateFromSerializable() throws Exception {
        RuleExecutionSet ruleExecutionSet = this.ruleSetProvider.createRuleExecutionSet((Serializable)this.pkg, null);
        Assert.assertEquals((String)"rule set name", (Object)"SistersRules", (Object)ruleExecutionSet.getName());
        Assert.assertEquals((String)"number of rules", (long)1L, (long)ruleExecutionSet.getRules().size());
    }

    @Test
    public void testCreateFromURI() throws Exception {
        String rulesUri = RuleEngineTestBase.class.getResource(this.bindUri).toExternalForm();
        RuleExecutionSet testRuleSet = this.ruleSetProvider.createRuleExecutionSet(rulesUri, null);
        Assert.assertEquals((String)"rule set name", (Object)"SistersRules", (Object)testRuleSet.getName());
        Assert.assertEquals((String)"number of rules", (long)1L, (long)testRuleSet.getRules().size());
    }

    @Test
    public void testIncompatibleSerializableCreation() throws Exception {
        try {
            RuleExecutionSet testRuleSet = this.ruleSetProvider.createRuleExecutionSet(new ArrayList(), null);
            Assert.fail((String)("Should have thrown an IllegalArgumentException. ArrayList objects are not valid AST representations. " + testRuleSet));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

