/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import javax.rules.RuleServiceProvider;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import org.drools.jsr94.rules.ExampleRuleEngineFacade;
import org.junit.Before;

public abstract class RuleEngineTestBase {
    protected StatefulRuleSession statefulSession;
    protected StatelessRuleSession statelessSession;
    protected ExampleRuleEngineFacade engine;
    protected String bindUri = "sisters.drl";
    protected String bindUri_drl = "sisters_expander.drl";
    protected String bindUri_dsl = "sisters_expander.dsl";
    protected String bindUri_globals = "sisters_globals.drl";
    protected RuleServiceProvider ruleServiceProvider;

    @Before
    public void setUp() throws Exception {
        this.engine = new ExampleRuleEngineFacade();
        this.engine.addRuleExecutionSet(this.bindUri, RuleEngineTestBase.class.getResourceAsStream(this.bindUri));
        HashMap<String, String> map = new HashMap<String, String>();
        InputStreamReader reader = new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri_dsl));
        map.put("dsl", this.getDSLText(reader).toString());
        this.engine.addRuleExecutionSet(this.bindUri_drl, RuleEngineTestBase.class.getResourceAsStream(this.bindUri_drl), map);
        this.engine.addRuleExecutionSet(this.bindUri_globals, RuleEngineTestBase.class.getResourceAsStream(this.bindUri_globals));
        this.ruleServiceProvider = this.engine.getRuleServiceProvider();
    }

    private StringBuffer getDSLText(Reader reader) throws IOException {
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    protected URL getResource(String res) {
        return this.getClass().getClassLoader().getResource(res);
    }

    protected InputStream getResourceAsStream(String res) {
        return this.getClass().getClassLoader().getResourceAsStream(res);
    }
}

