/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleSessionCreateException;
import javax.rules.StatefulRuleSession;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.ObjectFilterAdapter;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepository;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepositoryException;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

public class StatefulRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatefulRuleSession {
    private static final long serialVersionUID = 510L;
    private KieSession session;

    StatefulRuleSessionImpl(String bindUri, Map properties, RuleExecutionSetRepository repository) throws RuleExecutionSetNotFoundException, RuleSessionCreateException {
        super(repository);
        this.setProperties(properties);
        RuleExecutionSetImpl ruleSet = null;
        try {
            ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri, properties);
        }
        catch (RuleExecutionSetRepositoryException e) {
            String s = "Error while retrieving rule execution set bound to: " + bindUri;
            throw new RuleSessionCreateException(s, (Exception)((Object)e));
        }
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("no execution set bound to: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
        SessionConfiguration conf = SessionConfiguration.newInstance();
        conf.setKeepReference(true);
        this.initSession(conf);
    }

    protected void initSession(SessionConfiguration conf) {
        this.session = this.getRuleExecutionSet().newStatefulSession(conf);
        Map props = this.getProperties();
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                this.session.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean containsObject(Handle objectHandle) {
        if (objectHandle instanceof FactHandle) {
            return this.session.getObject((FactHandle)objectHandle) != null;
        }
        return false;
    }

    public Handle addObject(Object object) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return (Handle)this.session.insert(object);
    }

    public List addObjects(List objList) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList<Handle> handles = new ArrayList<Handle>();
        Iterator objectIter = objList.iterator();
        while (objectIter.hasNext()) {
            handles.add(this.addObject(objectIter.next()));
        }
        return handles;
    }

    public void updateObject(Handle objectHandle, Object newObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (!(objectHandle instanceof FactHandle)) {
            throw new InvalidHandleException("invalid handle");
        }
        this.session.update((FactHandle)objectHandle, newObject);
    }

    public void removeObject(Handle handleObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (!(handleObject instanceof FactHandle)) {
            throw new InvalidHandleException("invalid handle");
        }
        this.session.retract((FactHandle)handleObject);
    }

    public void executeRules() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        this.session.fireAllRules();
    }

    public Object getObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            return this.session.getObject((FactHandle)handle);
        }
        throw new InvalidHandleException("invalid handle");
    }

    public List getHandles() {
        return new ArrayList(this.session.getFactHandles());
    }

    public List getObjects() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return this.getObjects(this.getRuleExecutionSet().getObjectFilter());
    }

    public List getObjects(javax.rules.ObjectFilter filter) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList<Object> list = new ArrayList<Object>();
        for (FactHandle fh : this.session.getFactHandles((ObjectFilter)new ObjectFilterAdapter(filter))) {
            list.add(((InternalFactHandle)fh).getObject());
        }
        return list;
    }

    public void reset() {
        this.initSession(SessionConfiguration.newInstance());
    }

    public int getType() throws InvalidRuleSessionException {
        return 0;
    }

    @Override
    public void release() {
        if (this.session != null) {
            this.session.dispose();
        }
        this.session = null;
        super.release();
    }

    @Override
    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.session == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }
}

