/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.repository;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepository;

public abstract class RuleExecutionSetRepositoryLoader {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RuleExecutionSetRepository loadRuleExecutionSetRepository(String defaultFactoryName) {
        PropertyAccessAction action;
        Object factory = null;
        String factoryName = null;
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        String propertyName = "org.drools.jsr94.rules.repository.RuleExecutionSetRepository";
        String fileName = "META-INF/services/" + propertyName;
        InputStream in = cL.getResourceAsStream(fileName);
        if (in != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                factoryName = reader.readLine();
                if (factoryName != null) {
                    factory = RuleExecutionSetRepositoryLoader.createFactory(cL, factoryName);
                }
            }
            catch (UnsupportedEncodingException e) {
                try {
                    throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, e);
                    catch (IOException e2) {
                        throw new IllegalStateException("Failed to load " + propertyName + ": " + factoryName, e2);
                    }
                }
                catch (Throwable throwable) {
                    RuleExecutionSetRepositoryLoader.close(reader);
                    throw throwable;
                }
            }
            RuleExecutionSetRepositoryLoader.close(reader);
        }
        if (factory == null) {
            // empty if block
        }
        if (factory == null && (factoryName = (String)AccessController.doPrivileged(action = new PropertyAccessAction(propertyName))) != null) {
            factory = RuleExecutionSetRepositoryLoader.createFactory(cL, factoryName);
        }
        if (factory == null && defaultFactoryName != null) {
            factory = RuleExecutionSetRepositoryLoader.createFactory(cL, defaultFactoryName);
        }
        return (RuleExecutionSetRepository)factory;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Object createFactory(ClassLoader cL, String factoryName) {
        try {
            Class<?> factoryClass = cL.loadClass(factoryName);
            return factoryClass.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to load: " + factoryName, t);
        }
    }

    private static class PropertyFileAccessAction
    implements PrivilegedAction {
        private String fileName;

        PropertyFileAccessAction(String fileName) {
            this.fileName = fileName;
        }

        public Object run() {
            Properties properties;
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.fileName);
                Properties props = new Properties();
                props.load(in);
                properties = props;
            }
            catch (IOException e) {
                try {
                    throw new SecurityException("Cannot load properties: " + this.fileName, e);
                }
                catch (Throwable throwable) {
                    RuleExecutionSetRepositoryLoader.close(in);
                    throw throwable;
                }
            }
            RuleExecutionSetRepositoryLoader.close(in);
            return properties;
        }
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;

        PropertyAccessAction(String name) {
            this.name = name;
        }

        public Object run() {
            return System.getProperty(this.name);
        }
    }
}

