/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.io.File;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.drools.camel.example.Person;
import org.drools.karaf.itest.OSGiIntegrationSpringTestSupport;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

@RunWith(value=JUnit4TestRunner.class)
public class DroolsOnBodyCamelKarafTest
extends OSGiIntegrationSpringTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(DroolsOnBodyCamelKarafTest.class);
    @Produce(ref="ruleOnBodyEndpoint")
    protected ProducerTemplate ruleOnBodyEndpoint;

    @Override
    protected OsgiBundleXmlApplicationContext createApplicationContext() {
        return new OsgiBundleXmlApplicationContext(new String[]{"org/drools/karaf/itest/camel-context.xml"});
    }

    @Test
    public void testRuleOnBody() throws Exception {
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        Person response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        DroolsOnBodyCamelKarafTest.assertNotNull((Object)response);
        DroolsOnBodyCamelKarafTest.assertFalse((boolean)person.isCanDrink());
        person.setName("Scott");
        person.setAge(21);
        response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        DroolsOnBodyCamelKarafTest.assertNotNull((Object)response);
        DroolsOnBodyCamelKarafTest.assertTrue((boolean)person.isCanDrink());
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject()).karafVersion(MavenUtils.getArtifactVersion((String)"org.apache.karaf", (String)"apache-karaf")).name("Apache Karaf").unpackDirectory(new File("target/exam/unpack/")), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), DroolsOnBodyCamelKarafTest.loadCamelFeatures("camel-cxf"), DroolsOnBodyCamelKarafTest.loadDroolsFeatures("drools-camel", "drools-spring")};
    }
}

