/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.io.File;
import java.util.Properties;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.drools.karaf.itest.KieSpringIntegrationTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.EagerSingleStagedReactorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={EagerSingleStagedReactorFactory.class})
public class KieSpringOnKarafTest
extends KieSpringIntegrationTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(KieSpringOnKarafTest.class);
    protected static final String DroolsVersion;

    @Before
    public void init() {
        this.applicationContext = this.createApplicationContext();
        Assert.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
    }

    @Test
    public void testKieBase() throws Exception {
        this.refresh();
        KieBase kbase = (KieBase)this.applicationContext.getBean("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testKieSession() throws Exception {
        this.refresh();
        StatelessKieSession ksession = (StatelessKieSession)this.applicationContext.getBean("ksession9");
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSessionDefaultType() throws Exception {
        this.refresh();
        Object obj = this.applicationContext.getBean("ksession99");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof KieSession));
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject()).karafVersion(MavenUtils.getArtifactVersion((String)"org.apache.karaf", (String)"apache-karaf")).name("Apache Karaf").unpackDirectory(new File("target/exam/unpack/")), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), CoreOptions.scanFeatures((UrlReference)CoreOptions.maven().groupId("org.apache.karaf.assemblies.features").artifactId("standard").type("xml").classifier("features").versionAsInProject(), (String[])new String[]{"spring", "spring-dm"}), KieSpringOnKarafTest.loadDroolsKieFeatures("kie-spring")};
    }

    protected OsgiBundleXmlApplicationContext createApplicationContext() {
        return new OsgiBundleXmlApplicationContext(new String[]{"org/drools/karaf/itest/kie-beans.xml"});
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(KieSpringOnKarafTest.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DroolsVersion property: " + e.getMessage(), e);
        }
        DroolsVersion = testProps.getProperty("project.version");
        LOG.info("Drools Project Version : " + DroolsVersion);
    }
}

