/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.osgi.CamelContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.drools.core.util.Drools;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafIntegrationTestSupport
extends CamelTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(KarafIntegrationTestSupport.class);
    @Inject
    protected BundleContext bundleContext;

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            LOG.warn("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    protected CamelContext createCamelContext() throws Exception {
        LOG.info("Get the bundleContext is " + this.bundleContext);
        LOG.info("Application installed as bundle id: " + this.bundleContext.getBundle().getBundleId());
        this.setThreadContextClassLoader();
        CamelContextFactory factory = new CamelContextFactory();
        factory.setBundleContext(this.bundleContext);
        factory.setRegistry((Registry)this.createRegistry());
        return factory.createContext();
    }

    protected void setThreadContextClassLoader() {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
    }

    public static MavenArtifactProvisionOption getFeatureUrl(String groupId, String camelId) {
        return CoreOptions.mavenBundle().groupId(groupId).artifactId(camelId);
    }

    public static UrlReference getCamelKarafFeatureUrl() {
        return KarafIntegrationTestSupport.getCamelKarafFeatureUrl(null);
    }

    public static UrlReference getCamelKarafFeatureUrl(String version) {
        String type = "xml/features";
        MavenArtifactProvisionOption mavenOption = CoreOptions.mavenBundle().groupId("org.apache.camel.karaf").artifactId("apache-camel");
        if (version == null) {
            return mavenOption.versionAsInProject().type(type);
        }
        return mavenOption.version(version).type(type);
    }

    public static Option loadCamelFeatures(String ... features) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("camel-core");
        result.add("camel-spring");
        result.add("camel-test");
        for (String feature : features) {
            result.add(feature);
        }
        return KarafDistributionOption.features((UrlReference)KarafIntegrationTestSupport.getCamelKarafFeatureUrl(), (String[])result.toArray(new String[result.size()]));
    }

    public static Option loadDroolsFeatures(String ... features) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("drools-module");
        for (String feature : features) {
            result.add(feature);
        }
        return KarafDistributionOption.features((UrlReference)KarafIntegrationTestSupport.getFeatureUrl("org.drools", "drools-karaf-features").type("xml").classifier("features").version(Drools.getFullVersion()), (String[])result.toArray(new String[4 + features.length]));
    }

    private static String getKarafVersion() {
        String karafVersion = System.getProperty("karafVersion");
        if (karafVersion == null) {
            karafVersion = "2.3.3";
        }
        return karafVersion;
    }

    public static Option getKarafDistributionOption() {
        String karafVersion = KarafIntegrationTestSupport.getKarafVersion();
        LOG.info("*** The karaf version is " + karafVersion + " ***");
        return KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject()).karafVersion(karafVersion).name("Apache Karaf").useDeployFolder(false).unpackDirectory(new File("target/paxexam/unpack/"));
    }
}

