/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.net.URL;
import java.util.Collection;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.drools.camel.example.Person;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.karaf.itest.CommonKarafOptions;
import org.drools.karaf.itest.OSGiIntegrationSpringTestSupport;
import org.drools.osgi.spring.OsgiApplicationContextFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.builder.ReleaseId;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

@RunWith(value=PaxExam.class)
public class DroolsOnCommandCamelKarafIntegrationTest
extends OSGiIntegrationSpringTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(DroolsOnCommandCamelKarafIntegrationTest.class);
    @Produce(ref="ruleOnCommandEndpoint")
    protected ProducerTemplate ruleOnCommandEndpoint;

    @Override
    protected OsgiBundleXmlApplicationContext createApplicationContext() {
        return OsgiApplicationContextFactory.getOsgiSpringContext((ReleaseId)new ReleaseIdImpl("dummyGroup", "dummyArtifact", "dummyVersion"), (URL)DroolsOnCommandCamelKarafIntegrationTest.class.getResource("/org/drools/karaf/itest/camel-context.xml"));
    }

    @Test
    public void testRuleOnCommand() throws Exception {
        Object value;
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        ExecutionResultImpl response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)response);
        Collection identifiers = response.getIdentifiers();
        DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)identifiers);
        DroolsOnCommandCamelKarafIntegrationTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)value);
            DroolsOnCommandCamelKarafIntegrationTest.assertIsInstanceOf(Person.class, (Object)value);
            DroolsOnCommandCamelKarafIntegrationTest.assertFalse((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
        person.setName("Scott");
        person.setAge(21);
        response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)response);
        identifiers = response.getIdentifiers();
        DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)identifiers);
        DroolsOnCommandCamelKarafIntegrationTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            DroolsOnCommandCamelKarafIntegrationTest.assertNotNull((Object)value);
            DroolsOnCommandCamelKarafIntegrationTest.assertIsInstanceOf(Person.class, (Object)value);
            DroolsOnCommandCamelKarafIntegrationTest.assertTrue((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
    }

    @Configuration
    public static Option[] configure() {
        return OptionUtils.combine((Option[])CommonKarafOptions.get(), (Option[])new Option[]{DroolsOnCommandCamelKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), DroolsOnCommandCamelKarafIntegrationTest.loadCamelFeatures("camel-cxf"), DroolsOnCommandCamelKarafIntegrationTest.loadDroolsFeatures("kie-spring", "kie-camel")});
    }
}

