/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.drools.karaf.itest.CommonKarafOptions;
import org.drools.karaf.itest.KarafIntegrationTestSupport;
import org.drools.karaf.itest.KieSpringIntegrationTestSupport;
import org.h2.tools.Server;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerMethod.class})
public class KieSpringjBPMPersistenceOnKarafIntegrationTest
extends KieSpringIntegrationTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(KieSpringjBPMPersistenceOnKarafIntegrationTest.class);
    protected static final String DroolsVersion;

    @Before
    public void init() {
        this.applicationContext = this.createApplicationContext();
        Assert.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
    }

    @Test
    public void testJbpmRuntimeManager() {
        this.refresh();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource("Evaluation.bpmn", this.getClass().getClassLoader()), ResourceType.BPMN2).get();
        RuntimeManager runtimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        KieSession ksession = runtimeManager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        LOG.info("Start process Evaluation (bpmn2)");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "krisv");
        params.put("reason", "Yearly performance evaluation");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        LOG.info("Started process instance " + processInstance.getId());
    }

    @Test
    public void testJbpmRuntimeManagerWithPersistence() {
        Server server = KieSpringjBPMPersistenceOnKarafIntegrationTest.startH2Server();
        this.refresh();
        Properties props = new Properties();
        props.setProperty("krisv", "IT");
        props.setProperty("john", "HR");
        props.setProperty("mary", "PM");
        EntityManagerFactory emf = (EntityManagerFactory)this.applicationContext.getBean("myEmf");
        PlatformTransactionManager txManager = (PlatformTransactionManager)this.applicationContext.getBean("txManager");
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)txManager).addAsset(KieServices.Factory.get().getResources().newClassPathResource("Evaluation.bpmn", this.getClass().getClassLoader()), ResourceType.BPMN2).userGroupCallback((UserGroupCallback)new JBossUserGroupCallbackImpl(props)).get();
        RuntimeManager runtimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        RuntimeEngine runtimeEngine = runtimeManager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "krisv");
        params.put("reason", "Yearly performance evaluation");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        System.out.println("Process instance " + processInstance.getId() + " started ...");
        ProcessInstance pi = ksession.getProcessInstance(processInstance.getId());
        System.out.println(pi);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        TaskSummary task = (TaskSummary)tasks.get(0);
        System.out.println("'krisv' completing task " + task.getName() + ": " + task.getDescription());
        taskService.start(task.getId().longValue(), "krisv");
        Map vars = taskService.getTaskContent(task.getId().longValue());
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("performance", "exceeding");
        taskService.complete(task.getId().longValue(), "krisv", results);
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        task = (TaskSummary)tasks.get(0);
        System.out.println("'john' completing task " + task.getName() + ": " + task.getDescription());
        taskService.claim(task.getId().longValue(), "john");
        taskService.start(task.getId().longValue(), "john");
        results = new HashMap();
        results.put("performance", "acceptable");
        taskService.complete(task.getId().longValue(), "john", results);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)tasks.get(0);
        System.out.println("'mary' completing task " + task.getName() + ": " + task.getDescription());
        taskService.claim(task.getId().longValue(), "mary");
        taskService.start(task.getId().longValue(), "mary");
        results = new HashMap();
        results.put("performance", "outstanding");
        taskService.complete(task.getId().longValue(), "mary", results);
        System.out.println("Process instance completed");
        runtimeManager.disposeRuntimeEngine(runtimeEngine);
        runtimeManager.close();
        server.shutdown();
    }

    public static Server startH2Server() {
        try {
            Server server = Server.createTcpServer((String[])new String[0]);
            server.start();
            return server;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start H2 server", t);
        }
    }

    @Configuration
    public static Option[] configure() {
        return OptionUtils.combine((Option[])CommonKarafOptions.get(), (Option[])new Option[]{KarafIntegrationTestSupport.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KarafIntegrationTestSupport.loadCamelFeatures(new String[0]), KieSpringjBPMPersistenceOnKarafIntegrationTest.loadDroolsKieFeatures("jbpm-spring-persistent")});
    }

    protected OsgiBundleXmlApplicationContext createApplicationContext() {
        return new OsgiBundleXmlApplicationContext(new String[]{"org/drools/karaf/itest/kie-beans-persistence.xml"});
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(KieSpringjBPMPersistenceOnKarafIntegrationTest.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DroolsVersion property: " + e.getMessage(), e);
        }
        DroolsVersion = testProps.getProperty("project.version");
        LOG.info("Drools Project Version : " + DroolsVersion);
    }
}

