/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.karaf.itest.AbstractKarafIntegrationTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.command.Command;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerMethod.class})
public class KieServerClientOnKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(KieServerClientOnKarafIntegrationTest.class);
    private static final String SERVER_URL = System.getProperty("org.kie.server.itest.server.url", "http://localhost:8080/kie-server/services/rest/server");
    private static final String USER = System.getProperty("org.kie.server.itest.user", "kieserver");
    private static final String PASSWORD = System.getProperty("org.kie.server.itest.password", "kieserver@pwd1");
    private static final String CONTAINER_ID = System.getProperty("org.kie.server.itest.container", "evaluationproject");
    private static final String PROCESS_ID = System.getProperty("org.kie.server.itest.process", "evaluation");

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testListContainersJSON() throws Exception {
        this.testListContainers(MarshallingFormat.JSON);
    }

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testListContainersJAXB() throws Exception {
        this.testListContainers(MarshallingFormat.JAXB);
    }

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testListContainersXSTREAM() throws Exception {
        this.testListContainers(MarshallingFormat.XSTREAM);
    }

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testCompleteInteractionWithKieServerJSON() throws Exception {
        this.testCompleteInteractionWithKieServer(MarshallingFormat.JSON);
    }

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testCompleteInteractionWithKieServerJAXB() throws Exception {
        this.testCompleteInteractionWithKieServer(MarshallingFormat.JAXB);
    }

    @Ignore(value="Ignored by default as it requires KieServer up and running to perform this test")
    @Test
    public void testCompleteInteractionWithKieServerXSTREAM() throws Exception {
        this.testCompleteInteractionWithKieServer(MarshallingFormat.XSTREAM);
    }

    protected void testListContainers(MarshallingFormat marshallingFormat) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)SERVER_URL, (String)USER, (String)PASSWORD);
        configuration.setMarshallingFormat(marshallingFormat);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        ServiceResponse containersResponse = kieServicesClient.listContainers();
        Assert.assertNotNull((Object)containersResponse);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)containersResponse.getType());
        Assert.assertNotNull((Object)containersResponse.getResult());
        List containers = ((KieContainerResourceList)containersResponse.getResult()).getContainers();
        Assert.assertNotNull((Object)containers);
        logger.info("Found containers = " + containers);
        Assert.assertTrue((containers.size() > 0 ? 1 : 0) != 0);
    }

    protected void testCompleteInteractionWithKieServer(MarshallingFormat marshallingFormat) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)SERVER_URL, (String)USER, (String)PASSWORD);
        configuration.setMarshallingFormat(marshallingFormat);
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        QueryServicesClient queryClient = (QueryServicesClient)kieServicesClient.getServicesClient(QueryServicesClient.class);
        List processes = queryClient.findProcesses(Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("\t######### Available processes" + processes);
        ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
        ProcessDefinition definition = processClient.getProcessDefinition(CONTAINER_ID, PROCESS_ID);
        System.out.println("\t######### Definition details: " + definition);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", USER);
        Long processInstanceId = processClient.startProcess(CONTAINER_ID, PROCESS_ID, params);
        System.out.println("\t######### Process instance id: " + processInstanceId);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
        List tasks = taskClient.findTasks(USER, Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("\t######### Tasks: " + tasks);
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskClient.startTask(CONTAINER_ID, taskId, USER);
        taskClient.completeTask(CONTAINER_ID, taskId, USER, null);
        ArrayList<Object> commands = new ArrayList<Object>();
        BatchExecutionCommandImpl executionCommand = new BatchExecutionCommandImpl(commands);
        executionCommand.setLookup("defaultKieSession");
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand();
        insertObjectCommand.setOutIdentifier("person");
        insertObjectCommand.setObject((Object)"john");
        FireAllRulesCommand fireAllRulesCommand = new FireAllRulesCommand();
        commands.add(insertObjectCommand);
        commands.add(fireAllRulesCommand);
        RuleServicesClient ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
        ruleClient.executeCommands(CONTAINER_ID, (Command)executionCommand);
        System.out.println("\t######### Rules executed");
        processClient.abortProcessInstance(CONTAINER_ID, processInstanceId);
        ProcessInstance processInstance = queryClient.findProcessInstanceById(processInstanceId);
        System.out.println("\t######### ProcessInstance: " + processInstance);
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieServerClientOnKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KieServerClientOnKarafIntegrationTest.loadKieFeatures("kie-server-client")};
    }
}

