/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.drools.karaf.itest.AbstractKieSpringKarafIntegrationTest;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKarafIntegrationTest {
    public static final String PROP_KARAF_DISTRIBUTION_FILE = "karaf.dist.file";
    public static final String PROP_KARAF_MAXPERMSIZE = "karaf.maxpermsize";
    public static final String PROP_KEEP_RUNTIME_FOLDER = "karaf.keep.runtime.folder";
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractKarafIntegrationTest.class);
    protected static final String DROOLS_VERSION;
    @Inject
    protected BundleContext bundleContext;

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            logger.warn("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    private static String getKarafVersion() {
        String karafVersion = System.getProperty("karafVersion");
        if (karafVersion == null) {
            karafVersion = "2.4.2";
        }
        return karafVersion;
    }

    public static Option getKarafDistributionOption() {
        ArrayList<Object> options = new ArrayList<Object>();
        String karafVersion = AbstractKarafIntegrationTest.getKarafVersion();
        logger.info("*** The karaf version is " + karafVersion + " ***");
        KarafDistributionBaseConfigurationOption karafConfiguration = KarafDistributionOption.karafDistributionConfiguration();
        if (System.getProperty(PROP_KARAF_DISTRIBUTION_FILE) == null) {
            karafConfiguration.frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").versionAsInProject());
        } else {
            File fuseDistributionFile = new File(System.getProperty(PROP_KARAF_DISTRIBUTION_FILE));
            karafConfiguration.frameworkUrl("file:" + fuseDistributionFile.getAbsolutePath());
        }
        karafConfiguration.karafVersion(karafVersion).name("Apache Karaf").useDeployFolder(false).unpackDirectory(new File("target/paxexam/unpack/"));
        options.add(karafConfiguration);
        if (System.getProperty(PROP_KARAF_MAXPERMSIZE) != null) {
            options.add(CoreOptions.vmOption((String)("-XX:MaxPermSize=" + System.getProperty(PROP_KARAF_MAXPERMSIZE))));
        }
        if (System.getProperty(PROP_KEEP_RUNTIME_FOLDER) != null) {
            options.add(KarafDistributionOption.keepRuntimeFolder());
        }
        options.add(AbstractKarafIntegrationTest.localMavenRepoOption());
        options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.repositories", (String)"http://repo1.maven.org/maven2@id=central,https://repository.jboss.org/nexus/content/groups/public@id=jboss-public"));
        return new DefaultCompositeOption(options.toArray(new Option[1]));
    }

    public static Option localMavenRepoOption() {
        String localRepo = System.getProperty("maven.repo.local", "");
        if (localRepo.length() > 0) {
            logger.info("Using alternative local Maven repository in {}.", (Object)new File(localRepo).getAbsolutePath());
        }
        return CoreOptions.when((localRepo.length() > 0 ? 1 : 0) != 0).useOptions(new Option[]{KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (String)new File(localRepo).getAbsolutePath())});
    }

    public static MavenArtifactProvisionOption getFeaturesUrl(String groupId, String artifactId, String version) {
        MavenArtifactProvisionOption mapo = CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
        mapo.type("xml");
        mapo.classifier("features");
        if (version == null) {
            mapo.versionAsInProject();
        } else {
            mapo.version(version);
        }
        logger.info("Features URL: " + mapo.getURL());
        return mapo;
    }

    public static Option loadKieFeaturesRepo() {
        return KarafDistributionOption.features((String)CoreOptions.maven().groupId("org.drools").artifactId("drools-karaf-features").type("xml").classifier("features").versionAsInProject().getURL(), (String[])new String[0]);
    }

    public static Option loadKieFeatures(String ... features) {
        MavenArtifactProvisionOption featuresUrl = AbstractKarafIntegrationTest.getFeaturesUrl("org.drools", "drools-karaf-features", DROOLS_VERSION);
        return KarafDistributionOption.features((UrlReference)featuresUrl, (String[])features);
    }

    public static Option loadKieFeatures(List<String> features) {
        return AbstractKarafIntegrationTest.loadKieFeatures(features.toArray(new String[features.size()]));
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(AbstractKieSpringKarafIntegrationTest.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DROOLS_VERSION property: " + e.getMessage(), e);
        }
        DROOLS_VERSION = testProps.getProperty("project.version");
        logger.info("Drools Project Version : " + DROOLS_VERSION);
    }
}

