/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.karaf.features.FeaturesService;
import org.drools.karaf.itest.AbstractKarafIntegrationTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExamParameterized;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;

@RunWith(value=PaxExamParameterized.class)
@ExamReactorStrategy(value={PerMethod.class})
public class InstallFeaturesAbstractKarafIntegrationTest
extends AbstractKarafIntegrationTest {
    private String featureName;
    @Inject
    protected FeaturesService featuresService;

    public InstallFeaturesAbstractKarafIntegrationTest(String featureName) {
        this.featureName = featureName;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<Object[]> getParameters() {
        return Arrays.asList({"drools-common"}, {"drools-module"}, {"drools-decisiontable"}, {"drools-jpa"}, {"kie-spring"}, {"kie-aries-blueprint"}, {"jbpm-commons"}, {"jbpm"}, {"jbpm-spring-persistent"}, {"hibernate-validator"});
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{InstallFeaturesAbstractKarafIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), InstallFeaturesAbstractKarafIntegrationTest.loadKieFeaturesRepo()};
    }

    @Test
    public void testInstallFeature() throws Exception {
        this.featuresService.installFeature(this.featureName);
        Assert.assertTrue((String)("Feature " + this.featureName + " not installed!"), (boolean)this.featuresService.isInstalled(this.featuresService.getFeature(this.featureName)));
    }
}

