/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest.blueprint;

import java.io.InputStream;
import javax.inject.Inject;
import org.drools.karaf.itest.AbstractKarafIntegrationTest;
import org.drools.karaf.itest.blueprint.KieBlueprintDependencyKarafIntegrationTest;
import org.drools.karaf.itest.blueprint.domain.Customer;
import org.drools.karaf.itest.blueprint.domain.Drink;
import org.drools.karaf.itest.blueprint.domain.Order;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieSession;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.ops4j.pax.tinybundles.core.TinyBundles;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerMethod.class})
public class KieBlueprintImportIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String BLUEPRINT_XML_LOCATION = "/org/drools/karaf/itest/blueprint/kie-scanner-import-blueprint.xml";
    @Inject
    KieSession kieSession;
    @Inject
    KieBase kieBase;
    @Inject
    KieScanner kieScanner;

    @Test
    public void kieElementsExistTest() {
        Assert.assertNotNull((Object)this.kieSession);
        Assert.assertNotNull((Object)this.kieBase);
        Assert.assertNotNull((Object)this.kieScanner);
    }

    @Test
    public void kieSessionOldPersonTest() {
        Assert.assertNotNull((Object)this.kieSession);
        Drink drink = new Drink("whiskey", true);
        Customer customer = new Customer("Customer", 40);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        Assert.assertTrue((boolean)order.isApproved());
    }

    @Test
    public void kieSessionYoungPersonTest() {
        Assert.assertNotNull((Object)this.kieSession);
        Drink drink = new Drink("whiskey", true);
        Customer customer = new Customer("Customer", 14);
        Order order = new Order(customer, drink);
        this.kieSession.insert((Object)order);
        this.kieSession.fireAllRules();
        Assert.assertFalse((boolean)order.isApproved());
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{KieBlueprintImportIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KieBlueprintImportIntegrationTest.loadKieFeatures("drools-module", "kie-ci", "kie-aries-blueprint"), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("junit").artifactId("junit").versionAsInProject()), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("org.drools").artifactId("drools-karaf-itests-domain-model").versionAsInProject()), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().add("OSGI-INF/blueprint/kie-scanner-import-blueprint.xml", KieBlueprintDependencyKarafIntegrationTest.class.getResource(BLUEPRINT_XML_LOCATION)).set("Bundle-SymbolicName", "Test-Blueprint-Bundle").set("Import-Package", "org.kie.aries.blueprint,org.osgi.service.blueprint.container,org.drools.karaf.itest.blueprint.domain,org.kie.aries.blueprint.factorybeans,org.kie.aries.blueprint.helpers,org.kie.api,org.kie.api.runtime,org.kie.api.builder,org.junit,*").set("Export-Package", "org.drools.karaf.itest.blueprint.domain").set("Bundle-SymbolicName", "Test-Blueprint-Bundle").build()).start()};
    }
}

