/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest.blueprint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import org.drools.karaf.itest.AbstractKarafIntegrationTest;
import org.drools.karaf.itest.blueprint.KieBlueprintDependencyKarafIntegrationTest;
import org.drools.karaf.itest.util.KieScannerTestUtils;
import org.drools.karaf.itest.util.TimerUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.ops4j.pax.tinybundles.core.TinyBundles;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerMethod.class})
public class KieBlueprintScannerReimportIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String BLUEPRINT_XML_LOCATION = "/org/drools/karaf/itest/blueprint/kie-scanner-reimport-blueprint.xml";
    private static final ReleaseId RELEASE_ID = KieServices.Factory.get().newReleaseId("org.drools.karaf.itest", "import-scanner-test-jar", "1.0.0-SNAPSHOT");
    private KieScannerTestUtils kieScannerTestUtils = new KieScannerTestUtils();
    @Inject
    KieBase kieBase;
    @Inject
    KieScanner kieScanner;

    private static void setup() {
        if (System.getProperty("maven.repo.local") != null) {
            InputStream testPropertiesStream = AbstractKarafIntegrationTest.class.getClassLoader().getResourceAsStream("test.properties");
            Properties testProperties = new Properties();
            try {
                testProperties.load(testPropertiesStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read test.properties file", e);
            }
            System.setProperty("kie.maven.settings.custom", testProperties.getProperty("kie.maven.settings.custom"));
        }
        KieScannerTestUtils kieScannerTestUtils = new KieScannerTestUtils();
        kieScannerTestUtils.setUp();
        kieScannerTestUtils.createAndInstallKJar(RELEASE_ID, "rule_0");
        kieScannerTestUtils.tearDown();
    }

    @After
    public void tearDown() {
        this.kieScannerTestUtils.tearDown();
    }

    @Test
    public void testKieBaseUpdatedByScanNow() {
        Assert.assertNotNull((Object)this.kieBase);
        KieSession kieSession = this.kieBase.newKieSession();
        Assert.assertNotNull((Object)kieSession);
        this.kieScannerTestUtils.createAndInstallKJar(RELEASE_ID, "rule_1");
        this.kieScanner.scanNow();
        kieSession = this.kieBase.newKieSession();
        this.kieScannerTestUtils.checkKSession(true, kieSession, "rule_1");
        this.kieScannerTestUtils.createAndInstallKJar(RELEASE_ID, "rule_2");
        this.kieScanner.scanNow();
        kieSession = this.kieBase.newKieSession();
        this.kieScannerTestUtils.checkKSession(true, kieSession, "rule_2");
    }

    @Test
    public void testKieBaseUpdatedByTimer() throws InterruptedException {
        Assert.assertNotNull((Object)this.kieBase);
        KieSession kieSession = this.kieBase.newKieSession();
        Assert.assertNotNull((Object)kieSession);
        this.kieScannerTestUtils.createAndInstallKJar(RELEASE_ID, "rule_1");
        TimerUtils.sleepMillis(2000L);
        kieSession = this.kieBase.newKieSession();
        this.kieScannerTestUtils.checkKSession(true, kieSession, "rule_1");
        this.kieScannerTestUtils.createAndInstallKJar(RELEASE_ID, "rule_2");
        TimerUtils.sleepMillis(2000L);
        kieSession = this.kieBase.newKieSession();
        this.kieScannerTestUtils.checkKSession(true, kieSession, "rule_2");
    }

    @Configuration
    public static Option[] configure() {
        KieBlueprintScannerReimportIntegrationTest.setup();
        return new Option[]{KieBlueprintScannerReimportIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.keepRuntimeFolder(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), KieBlueprintScannerReimportIntegrationTest.loadKieFeatures("drools-module", "kie-ci", "kie-aries-blueprint"), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("org.drools").artifactId("drools-karaf-itests-domain-model").versionAsInProject()), (Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().add("OSGI-INF/blueprint/kie-scanner-import-blueprint.xml", KieBlueprintDependencyKarafIntegrationTest.class.getResource(BLUEPRINT_XML_LOCATION)).set("Bundle-SymbolicName", "Test-Blueprint-Bundle").set("Import-Package", "org.kie.aries.blueprint,org.osgi.service.blueprint.container,org.drools.karaf.itest.blueprint.domain,org.kie.aries.blueprint.factorybeans,org.kie.aries.blueprint.helpers,org.kie.api,org.kie.api.runtime,org.kie.api.builder,*").set("Export-Package", "org.drools.karaf.itest.blueprint.domain").set("Bundle-SymbolicName", "Test-Blueprint-Bundle").build()).start()};
    }
}

