/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.spi.ProcessContext;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.task.model.OrganizationalEntity;

public class ProcessContextTest {
    @Test
    public void testProcessContextGetAssignment() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assert.assertNotNull((Object)ksession);
        CaseInformation caseInfo = new CaseInformation();
        caseInfo.assign("owner", new OrganizationalEntity(){

            public String getId() {
                return "testUser";
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }
        });
        ksession.insert((Object)caseInfo);
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseAssignment caseAssignment = processContext.getCaseAssignment();
        Assert.assertNotNull((Object)caseAssignment);
        Collection forRole = caseAssignment.getAssignments("owner");
        Assert.assertNotNull((Object)forRole);
        Assert.assertEquals((long)1L, (long)forRole.size());
    }

    @Test
    public void testProcessContextGetData() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assert.assertNotNull((Object)ksession);
        CaseInformation caseInfo = new CaseInformation();
        caseInfo.add("test", "value");
        ksession.insert((Object)caseInfo);
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseData caseData = processContext.getCaseData();
        Assert.assertNotNull((Object)caseData);
        Map allData = caseData.getData();
        Assert.assertNotNull((Object)allData);
        Assert.assertEquals((long)1L, (long)allData.size());
        Assert.assertEquals((Object)"value", (Object)caseData.getData("test"));
    }

    @Test
    public void testProcessContextGetDataAndAssignmentWithoutInsert() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = kbase.newKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessContext processContext = new ProcessContext((KieRuntime)ksession);
        CaseData caseData = processContext.getCaseData();
        Assert.assertNull((Object)caseData);
        CaseAssignment caseAssignment = processContext.getCaseAssignment();
        Assert.assertNull((Object)caseAssignment);
    }

    private class CaseInformation
    implements CaseData,
    CaseAssignment {
        private String definitionId;
        private Map<String, Object> data = new HashMap<String, Object>();
        private Map<String, OrganizationalEntity> assignment = new HashMap<String, OrganizationalEntity>();

        private CaseInformation() {
        }

        public void assign(String roleName, OrganizationalEntity entity) {
            this.assignment.put(roleName, entity);
        }

        public void assignUser(String roleName, String userId) {
        }

        public void assignGroup(String roleName, String groupId) {
        }

        public void remove(String roleName, OrganizationalEntity entity) {
            this.assignment.remove(roleName);
        }

        public Collection<OrganizationalEntity> getAssignments(String roleName) {
            OrganizationalEntity entity = this.assignment.get(roleName);
            if (entity == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(entity);
        }

        public Collection<String> getRoles() {
            return this.assignment.keySet();
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public Object getData(String name) {
            return this.data.get(name);
        }

        public void add(String name, Object data) {
            this.data.put(name, data);
        }

        public void remove(String name) {
            this.data.remove(name);
        }

        public String getDefinitionId() {
            return this.definitionId;
        }
    }
}

