/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;

public class ReteTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.pctxFactory = new PhreakPropagationContextFactory();
        this.buildContext = new BuildContext((RuleBase)this.kBase, Collections.emptyList());
        this.entryPoint = (EntryPointNode)this.buildContext.getRuleBase().getRete().getEntryPointNodes().values().iterator().next();
    }

    @Test
    public void testObjectTypeNodes() throws Exception {
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Object.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        ObjectTypeNode stringTypeNode = new ObjectTypeNode(2, this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        stringTypeNode.attach(this.buildContext);
        List list = rete.getObjectTypeNodes();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(objectTypeNode));
        Assert.assertTrue((boolean)list.contains(stringTypeNode));
    }

    @Test
    public void testCache() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Collection.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(ArrayList.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, new ArrayList());
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        h1.setObject(new ArrayList());
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        ClassObjectTypeConf conf = (ClassObjectTypeConf)ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        this.assertLength(3, conf.getObjectTypeNodes());
        conf = (ClassObjectTypeConf)ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        this.assertLength(3, conf.getObjectTypeNodes());
    }

    @Test
    public void testAssertObject() throws Exception {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string = "String";
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)"String");
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        this.assertLength(0, sink1.getAsserted());
        ArrayList list = new ArrayList();
        DefaultFactHandle h2 = new DefaultFactHandle(1L, list);
        rete.assertObject((InternalFactHandle)h2, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        ksession.fireAllRules();
        List asserted = sink1.getAsserted();
        this.assertLength(1, asserted);
        Object[] results = (Object[])asserted.get(0);
        Assert.assertSame(list, (Object)((DefaultFactHandle)results[0]).getObject());
    }

    @Test
    public void testAssertObjectWithNoMatchingObjectTypeNode() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        Assert.assertEquals((long)1L, (long)rete.getObjectTypeNodes().size());
        ArrayList list = new ArrayList();
        ksession.insert(list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rete.getObjectTypeNodes().size());
    }

    @Test
    @Ignore
    public void testHierarchy() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getNodeIdsGenerator();
        ObjectTypeNode listOtn = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        listOtn.attach(this.buildContext);
        FactHandle handle = ksession.insert(new ArrayList());
        Assert.assertEquals((long)3L, (long)rete.getObjectTypeNodes().size());
        Assert.assertSame((Object)listOtn, rete.getObjectTypeNodes(EntryPointId.DEFAULT).get(new ClassObjectType(List.class)));
        ClassObjectTypeConf arrayConf = (ClassObjectTypeConf)ksession.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        ObjectTypeNode arrayOtn = arrayConf.getConcreteObjectTypeNode();
        Assert.assertEquals((long)2L, (long)arrayConf.getObjectTypeNodes().length);
        List<ObjectTypeNode> nodes = Arrays.asList(arrayConf.getObjectTypeNodes());
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(arrayOtn));
        Assert.assertTrue((boolean)nodes.contains(listOtn));
        ksession.retract(handle);
        MockObjectSink listSink = new MockObjectSink();
        listOtn.addObjectSink((ObjectSink)listSink);
        MockObjectSink arraySink = new MockObjectSink();
        listOtn.addObjectSink((ObjectSink)arraySink);
        ksession.insert(new ArrayList());
        Assert.assertEquals((long)1L, (long)listSink.getAsserted().size());
        Assert.assertEquals((long)1L, (long)arraySink.getAsserted().size());
        ObjectTypeNode collectionOtn = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(Collection.class), this.buildContext);
        MockObjectSink collectionSink = new MockObjectSink();
        collectionOtn.addObjectSink((ObjectSink)collectionSink);
        collectionOtn.attach((BuildContext)new TestBuildContext(this.kBase));
        Assert.assertEquals((long)1L, (long)collectionSink.getAsserted().size());
        nodes = Arrays.asList(arrayConf.getObjectTypeNodes());
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(arrayOtn));
        Assert.assertTrue((boolean)nodes.contains(listOtn));
        Assert.assertTrue((boolean)nodes.contains(collectionOtn));
    }

    @Test
    public void testRetractObject() throws Exception {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string = "String";
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)"String");
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        this.assertLength(0, sink1.getAsserted());
        this.assertLength(0, sink1.getRetracted());
        ArrayList list = new ArrayList();
        DefaultFactHandle h2 = new DefaultFactHandle(1L, list);
        rete.assertObject((InternalFactHandle)h2, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        rete.retractObject((InternalFactHandle)h2, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        ksession.fireAllRules();
        List retracted = sink1.getRetracted();
        this.assertLength(1, retracted);
        Object[] results = (Object[])retracted.get(0);
        Assert.assertSame(list, (Object)((DefaultFactHandle)results[0]).getObject());
    }

    @Test
    public void testIsShadowed() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newKieSession();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("brie", 15);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)cheese);
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        ksession.fireAllRules();
        Object[] results = (Object[])sink1.getAsserted().get(0);
    }

    @Test
    @Ignore
    public void testNotShadowed() {
        Properties properties = new Properties();
        properties.setProperty("drools.shadowProxyExcludes", "org.drools.core.test.model.Cheese");
        RuleBaseConfiguration conf = new RuleBaseConfiguration(properties);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)conf);
        this.buildContext = new BuildContext((RuleBase)kBase, Collections.emptyList());
        StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl(1L, kBase);
        Rete rete = kBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)rete, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("brie", 15);
        DefaultFactHandle h1 = new DefaultFactHandle(1L, (Object)cheese);
        rete.assertObject((InternalFactHandle)h1, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null), (ReteEvaluator)ksession);
        ksession.fireAllRules();
        Object[] results = (Object[])sink1.getAsserted().get(0);
    }

    public static class TestBuildContext
    extends BuildContext {
        InternalKnowledgeBase kBase;

        TestBuildContext(InternalKnowledgeBase kBase) {
            super((RuleBase)kBase, Collections.emptyList());
            this.kBase = kBase;
        }
    }
}

