/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieSession;

public class ReteooRuleBaseMultiThreadedTest
extends DroolsTestCase {
    InternalKnowledgeBase kBase;
    RuleImpl rule;
    InternalKnowledgePackage pkg;

    @Before
    public void setUp() {
        this.kBase = KnowledgeBaseFactory.newKnowledgeBase();
        this.pkg = CoreComponentFactory.get().createKnowledgePackage("org.droos.test");
        JavaDialectRuntimeData data = new JavaDialectRuntimeData();
        data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.kBase.getRootClassLoader());
        this.pkg.getDialectRuntimeRegistry().setDialectData("java", (DialectRuntimeData)data);
        this.rule = new RuleImpl("Test");
        this.rule.setDialect("java");
        this.rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, ReteEvaluator reteEvaluator) throws Exception {
            }

            public String getName() {
                return "default";
            }
        });
        this.pkg.addRule(this.rule);
        this.kBase.addPackage((KiePackage)this.pkg);
    }

    @Test
    @Ignore
    public void testNewSessionWhileModifyingRuleBase() throws InterruptedException {
        boolean deadlockDetected;
        PackageModifier modifier = new PackageModifier();
        SessionCreator creator = new SessionCreator();
        creator.start();
        modifier.start();
        Thread.sleep(10000L);
        boolean bl = deadlockDetected = creator.isBlocked() && modifier.isBlocked();
        if (deadlockDetected) {
            this.printThreadStatus(creator);
            this.printThreadStatus(modifier);
        }
        Assert.assertEquals((String)"Threads are deadlocked! See previous stacks for more detail", (Object)false, (Object)deadlockDetected);
        if (creator.isInError()) {
            creator.getError().printStackTrace();
        }
        Assert.assertEquals((String)"Exception in creator thread", (Object)false, (Object)creator.isInError());
        if (modifier.isInError()) {
            modifier.getError().printStackTrace();
        }
        Assert.assertEquals((String)"Exception in modifier thread", (Object)false, (Object)modifier.isInError());
    }

    private void printThreadStatus(Thread thread) {
        StackTraceElement[] frames = thread.getStackTrace();
        System.err.println(thread.getName() + ": " + (Object)((Object)thread.getState()));
        for (StackTraceElement frame : frames) {
            System.err.println(frame);
        }
        System.err.println();
    }

    private class SessionCreator
    extends BlockedThread {
        private SessionCreator() {
            super("Session Creator Thread");
        }

        @Override
        void doOperation() {
            KieSession session = null;
            try {
                session = ReteooRuleBaseMultiThreadedTest.this.kBase.newKieSession();
            }
            finally {
                if (session != null) {
                    session.dispose();
                }
            }
        }
    }

    private class PackageModifier
    extends BlockedThread {
        private PackageModifier() {
            super("Rulebase Modifier Thread");
        }

        @Override
        void doOperation() {
            ReteooRuleBaseMultiThreadedTest.this.kBase.removeKiePackage(ReteooRuleBaseMultiThreadedTest.this.pkg.getName());
            ReteooRuleBaseMultiThreadedTest.this.kBase.addPackage((KiePackage)ReteooRuleBaseMultiThreadedTest.this.pkg);
        }
    }

    private abstract class BlockedThread
    extends Thread {
        private static final int NUMER_ATTEMPTS = 50000;
        private volatile Throwable error;

        BlockedThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        public boolean isInError() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }

        public boolean isBlocked() {
            return this.getState() == Thread.State.BLOCKED;
        }

        @Override
        public void run() {
            try {
                for (int numAttempts = 0; numAttempts < 50000; ++numAttempts) {
                    this.doOperation();
                }
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        abstract void doOperation();
    }
}

