/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.util.Properties;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.PriorityQueueAgendaGroupFactory;
import org.junit.Assert;
import org.junit.Test;

public class RuleBaseConfigurationTest {
    @Test
    public void testSystemProperties() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        System.setProperty("drools.equalityBehavior", "EQUALITY");
        cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
        System.getProperties().remove("drools.equalityBehavior");
    }

    @Test
    public void testProgrammaticPropertiesFile() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        Assert.assertEquals((Object)true, (Object)cfg.isIndexLeftBetaMemory());
        Properties properties = new Properties();
        properties.setProperty("drools.indexLeftBetaMemory", "false");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)false, (Object)cfg.isIndexLeftBetaMemory());
        System.getProperties().remove("drools.indexLeftBetaMemory");
    }

    @Test
    public void testAssertBehaviour() {
        Properties properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "identity");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        properties = new Properties();
        properties.setProperty("drools.equalityBehavior", "equality");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
    }

    @Test
    public void testSequential() {
        Properties properties = new Properties();
        properties.setProperty("drools.sequential", "false");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        Assert.assertFalse((boolean)cfg.isSequential());
        Assert.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "sequential");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertTrue((boolean)cfg.isSequential());
        Assert.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL, (Object)cfg.getSequentialAgenda());
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "dynamic");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        Assert.assertTrue((boolean)cfg.isSequential());
        Assert.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.DYNAMIC, (Object)cfg.getSequentialAgenda());
        Assert.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
    }
}

