/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.util.ObjectHashMap;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class ObjectHashMapTest {
    @Test
    public void testEqualityWithResize() {
        FactHandle handle;
        String s;
        int i;
        KieBaseConfiguration kconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kconf));
        KieSession ksession = kbase.newKieSession();
        int length = 300000;
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>(1000);
        ArrayList<String> objects = new ArrayList<String>(1000);
        for (i = 0; i < length; ++i) {
            s = this.getPropertyName(i);
            handle = ksession.insert((Object)s);
            objects.add(s);
            handles.add(handle);
        }
        for (i = 0; i < length; ++i) {
            s = (String)objects.get(i);
            handle = (FactHandle)handles.get(i);
            Assertions.assertThat((Object)ksession.getObject(handle)).isEqualTo((Object)s);
            Assertions.assertThat((Object)ksession.getFactHandle((Object)s)).isSameAs((Object)handle);
            handle = DefaultFactHandle.createFromExternalFormat((String)((DefaultFactHandle)handle).toExternalForm());
            Assertions.assertThat((Object)ksession.getObject(handle)).isEqualTo((Object)s);
        }
        for (i = 0; i < length; ++i) {
            FactHandle handle2 = (FactHandle)handles.get(i);
            handle2 = DefaultFactHandle.createFromExternalFormat((String)((DefaultFactHandle)handle2).toExternalForm());
            ksession.retract(handle2);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(length - i - 1);
            Assertions.assertThat((int)ksession.getFactHandles().size()).isEqualTo(length - i - 1);
        }
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getFactHandles().size()).isEqualTo(0);
    }

    @Test
    public void testIdentityWithResize() {
        FactHandle handle;
        String s;
        int i;
        KieBaseConfiguration kconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)EqualityBehaviorOption.IDENTITY);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((RuleBase)RuleBaseFactory.newRuleBase((KieBaseConfiguration)kconf));
        KieSession ksession = kbase.newKieSession();
        int length = 300;
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>(1000);
        ArrayList<String> objects = new ArrayList<String>(1000);
        for (i = 0; i < length; ++i) {
            s = this.getPropertyName(i);
            handle = ksession.insert((Object)s);
            objects.add(s);
            handles.add(handle);
        }
        for (i = 0; i < length; ++i) {
            s = (String)objects.get(i);
            handle = (FactHandle)handles.get(i);
            Assertions.assertThat((Object)ksession.getObject(handle)).isEqualTo((Object)s);
            Assertions.assertThat((Object)ksession.getFactHandle((Object)s)).isSameAs((Object)handle);
            handle = DefaultFactHandle.createFromExternalFormat((String)((DefaultFactHandle)handle).toExternalForm());
            Assertions.assertThat((Object)ksession.getObject(handle)).isEqualTo((Object)s);
        }
        for (i = 0; i < length; ++i) {
            FactHandle handle2 = (FactHandle)handles.get(i);
            handle2 = DefaultFactHandle.createFromExternalFormat((String)((DefaultFactHandle)handle2).toExternalForm());
            ksession.retract(handle2);
            Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(length - i - 1);
            Assertions.assertThat((int)ksession.getFactHandles().size()).isEqualTo(length - i - 1);
        }
        Assertions.assertThat((int)ksession.getObjects().size()).isEqualTo(0);
        Assertions.assertThat((int)ksession.getFactHandles().size()).isEqualTo(0);
    }

    public String getPropertyName(int i) {
        char c1 = (char)(65 + i / 3);
        char c2 = (char)(97 + i / 3);
        return c1 + "bl" + i + c2 + "blah";
    }

    @Test
    public void testEmptyIterator() {
        ObjectHashMap map = new ObjectHashMap();
        org.drools.core.util.Iterator it = map.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            Assertions.fail((String)"Map is empty, there should be no iteration");
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    @Test
    public void testStringData() {
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val);
            Assertions.assertThat((Object)map.get((Object)key)).isEqualTo((Object)val);
        }
    }

    @Test
    public void testIntegerData() {
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            Integer key = new Integer(idx);
            Integer val = new Integer(idx);
            map.put((Object)key, (Object)val);
            Assertions.assertThat((Object)map.get((Object)key)).isEqualTo((Object)val);
        }
    }

    @Test
    public void testJUHashmap() {
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        Assertions.assertThat(map).isNotNull();
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((CallSite)((Object)key), (CallSite)((Object)val));
            Assertions.assertThat(map.get(key)).isEqualTo((Object)val);
        }
    }

    @Test
    public void testStringDataDupFalse() {
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        int count = 10000;
        for (int idx = 0; idx < 10000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val, false);
            Assertions.assertThat((Object)map.get((Object)key)).isEqualTo((Object)val);
        }
    }

    @Test
    public void testJUHashMap1() {
        int count = 100000;
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        Assertions.assertThat(map).isNotNull();
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((CallSite)((Object)key), (CallSite)((Object)strval));
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap put(key,value) ET - " + (end - start));
    }

    @Test
    public void testStringData2() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap put(key,value) ET - " + (end - start));
    }

    @Test
    public void testStringData3() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            map.get((Object)key);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap get(key) ET - " + (end - start));
    }

    @Test
    public void testJUHashMap2() {
        int count = 100000;
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        Assertions.assertThat(map).isNotNull();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((CallSite)((Object)key), (CallSite)((Object)strval));
        }
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            map.get(key);
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap get(key) ET - " + (end - start));
    }

    @Test
    public void testStringData4() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval);
        }
        long start = System.currentTimeMillis();
        org.drools.core.util.Iterator itr = map.iterator();
        Object val = null;
        while ((val = itr.next()) != null) {
            val.hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap iterate ET - " + (end - start));
    }

    @Test
    public void testJUHashMap3() {
        int count = 100000;
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        Assertions.assertThat(map).isNotNull();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((CallSite)((Object)key), (CallSite)((Object)strval));
        }
        long start = System.currentTimeMillis();
        Iterator itr = map.values().iterator();
        while (itr.hasNext()) {
            itr.next().hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap iterate ET - " + (end - start));
    }

    @Test
    public void testStringData5() {
        int count = 100000;
        ObjectHashMap map = new ObjectHashMap();
        Assertions.assertThat((Object)map).isNotNull();
        long start = System.currentTimeMillis();
        for (int idx = 0; idx < 100000; ++idx) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put((Object)key, (Object)strval, false);
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom ObjectHashMap dup false ET - " + (end - start));
    }
}

