/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.command;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.junit.After;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;

public class MoreBatchExecutionTest
extends CommonTestMethodBase {
    private KieSession ksession = null;

    @After
    public void disposeKSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testFireAllRules() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/drl/test_ImportFunctions.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession((KieBase)kbase);
        Cheese cheese = new Cheese("stilton", 15);
        this.ksession.insert((Object)cheese);
        List list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newFireAllRules((String)"fired"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Batch execution result is null!", new Object[0])).isNotNull();
        Object firedObject = result.getValue("fired");
        ((AbstractBooleanAssert)Assertions.assertThat((firedObject != null && firedObject instanceof Integer ? 1 : 0) != 0).as("Retrieved object is null or incorrect!", new Object[0])).isTrue();
        Assertions.assertThat((Object)firedObject).isEqualTo((Object)4);
        list = (List)this.ksession.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule1");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule2");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule3");
        Assertions.assertThat(list.get(3)).isEqualTo((Object)"rule4");
    }

    @Test
    public void testQuery() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/simple_query_test.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession((KieBase)kbase);
        this.ksession.insert((Object)new Cheese("stinky", 5));
        this.ksession.insert((Object)new Cheese("smelly", 7));
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newQuery((String)"numStinkyCheeses", (String)"simple query"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Batch execution result is null!", new Object[0])).isNotNull();
        Object queryResultsObject = result.getValue("numStinkyCheeses");
        ((AbstractBooleanAssert)Assertions.assertThat((queryResultsObject != null && queryResultsObject instanceof QueryResults ? 1 : 0) != 0).as("Retrieved object is null or incorrect!", new Object[0])).isTrue();
        Assertions.assertThat((int)((QueryResults)queryResultsObject).size()).isEqualTo(1);
    }
}

