/*
 * Decompiled with CFR 0.152.
 */
package org.drools.runtime.pipeline.impl;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.ResultHandlerFactory;
import org.drools.runtime.pipeline.Service;
import org.drools.runtime.pipeline.impl.BaseService;

public class JmsMessenger
extends BaseService
implements Service {
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private MessageConsumer consumer;
    private Connection connection;
    private Session session;
    private ResultHandlerFactory resultHandlerFactory;
    private Pipeline pipeline;
    private Thread thread;
    private JmsMessengerRunner jmsFeederRunner;

    public JmsMessenger(Pipeline pipeline, Properties properties, String destinationName, ResultHandlerFactory resultHandlerFactory) {
        this.pipeline = pipeline;
        this.resultHandlerFactory = resultHandlerFactory;
        try {
            InitialContext jndiContext = new InitialContext(properties);
            this.connectionFactory = (ConnectionFactory)jndiContext.lookup("ConnectionFactory");
            this.destination = (Destination)jndiContext.lookup(destinationName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate JmsFeeder", e);
        }
    }

    public void start() {
        try {
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.consumer = this.session.createConsumer(this.destination);
            this.connection.start();
        }
        catch (Exception e) {
            this.handleException(this, null, e);
        }
        this.jmsFeederRunner = new JmsMessengerRunner(this, this.consumer, this.pipeline, this.resultHandlerFactory);
        this.jmsFeederRunner.setRun(true);
        this.thread = new Thread(this.jmsFeederRunner);
        this.thread.start();
    }

    public void stop() {
        try {
            this.jmsFeederRunner.setRun(false);
            this.consumer.close();
            this.connection.stop();
        }
        catch (JMSException e) {
            this.handleException(this, null, (Exception)((Object)e));
        }
    }

    public static class JmsMessengerRunner
    implements Runnable {
        private JmsMessenger feeder;
        private MessageConsumer consumer;
        private Pipeline pipeline;
        private ResultHandlerFactory resultHandlerFactory;
        private volatile boolean run;

        public JmsMessengerRunner(JmsMessenger feeder, MessageConsumer consumer, Pipeline pipeline, ResultHandlerFactory resultHandlerFactory) {
            this.feeder = feeder;
            this.consumer = consumer;
            this.pipeline = pipeline;
            this.resultHandlerFactory = resultHandlerFactory;
        }

        public void run() {
            while (this.run) {
                Message msg = null;
                try {
                    msg = this.consumer.receive();
                    if (this.resultHandlerFactory != null) {
                        this.pipeline.insert((Object)msg, this.resultHandlerFactory.newResultHandler());
                    } else {
                        this.pipeline.insert((Object)msg, null);
                    }
                    System.out.println("msg received : " + msg);
                }
                catch (JMSException e) {
                    this.feeder.handleException(this.feeder, msg, (Exception)((Object)e));
                }
            }
        }

        public void setRun(boolean run) {
            this.run = run;
        }
    }
}

