/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.example;

import java.util.Collection;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.test.junit4.CamelSpringTestSupport;
import org.drools.camel.example.Person;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelContextXmlTest
extends CamelSpringTestSupport {
    @Produce(uri="direct://ruleOnBody")
    protected ProducerTemplate ruleOnBodyEndpoint;
    @Produce(uri="direct://ruleOnCommand")
    protected ProducerTemplate ruleOnCommandEndpoint;

    @Test
    public void testRuleOnBody() throws Exception {
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        Person response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        CamelContextXmlTest.assertNotNull((Object)response);
        CamelContextXmlTest.assertFalse((boolean)person.isCanDrink());
        person.setName("Scott");
        person.setAge(21);
        response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        CamelContextXmlTest.assertNotNull((Object)response);
        CamelContextXmlTest.assertTrue((boolean)person.isCanDrink());
    }

    @Test
    public void testRuleOnCommand() throws Exception {
        Object value;
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        ExecutionResultImpl response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        CamelContextXmlTest.assertNotNull((Object)response);
        Collection identifiers = response.getIdentifiers();
        CamelContextXmlTest.assertNotNull((Object)identifiers);
        CamelContextXmlTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            CamelContextXmlTest.assertNotNull((Object)value);
            CamelContextXmlTest.assertIsInstanceOf(Person.class, (Object)value);
            CamelContextXmlTest.assertFalse((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
        person.setName("Scott");
        person.setAge(21);
        response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        CamelContextXmlTest.assertNotNull((Object)response);
        identifiers = response.getIdentifiers();
        CamelContextXmlTest.assertNotNull((Object)identifiers);
        CamelContextXmlTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            CamelContextXmlTest.assertNotNull((Object)value);
            CamelContextXmlTest.assertIsInstanceOf(Person.class, (Object)value);
            CamelContextXmlTest.assertTrue((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/camel-context.xml", "META-INF/spring/drools.xml"});
    }
}

