/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.example;

import java.util.Collection;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.test.junit4.CamelSpringTestSupport;
import org.drools.camel.example.Cheese;
import org.drools.camel.example.Person;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelDecisionTableTest
extends CamelSpringTestSupport {
    @Produce(uri="direct://ruleOnBodyDT")
    protected ProducerTemplate ruleOnBodyEndpoint;
    @Produce(uri="direct://ruleOnCommandDT")
    protected ProducerTemplate ruleOnCommandEndpoint;

    @Test
    @Ignore
    public void testRuleOnBody() throws Exception {
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        Cheese cheese = new Cheese();
        cheese.setPrice(10);
        cheese.setType("Stilton");
        this.ruleOnBodyEndpoint.requestBody((Object)cheese, Cheese.class);
        Person response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        CamelDecisionTableTest.assertNotNull((Object)response);
        CamelDecisionTableTest.assertFalse((boolean)person.isCanDrink());
        person.setName("Scott");
        person.setAge(21);
        response = (Person)this.ruleOnBodyEndpoint.requestBody((Object)person, Person.class);
        CamelDecisionTableTest.assertNotNull((Object)response);
        CamelDecisionTableTest.assertTrue((boolean)person.isCanDrink());
    }

    @Test
    @Ignore
    public void testRuleOnCommand() throws Exception {
        Object value;
        Person person = new Person();
        person.setName("Young Scott");
        person.setAge(18);
        Cheese cheese = new Cheese();
        cheese.setPrice(10);
        cheese.setType("Stilton");
        this.ruleOnBodyEndpoint.requestBody((Object)cheese, Cheese.class);
        this.ruleOnBodyEndpoint.requestBody((Object)cheese, Cheese.class);
        ExecutionResultImpl response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        CamelDecisionTableTest.assertNotNull((Object)response);
        Collection identifiers = response.getIdentifiers();
        CamelDecisionTableTest.assertNotNull((Object)identifiers);
        CamelDecisionTableTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            CamelDecisionTableTest.assertNotNull((Object)value);
            CamelDecisionTableTest.assertIsInstanceOf(Person.class, (Object)value);
            CamelDecisionTableTest.assertFalse((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
        person.setName("Scott");
        person.setAge(21);
        response = (ExecutionResultImpl)this.ruleOnCommandEndpoint.requestBody((Object)person, ExecutionResultImpl.class);
        CamelDecisionTableTest.assertNotNull((Object)response);
        identifiers = response.getIdentifiers();
        CamelDecisionTableTest.assertNotNull((Object)identifiers);
        CamelDecisionTableTest.assertTrue((identifiers.size() >= 1 ? 1 : 0) != 0);
        for (String identifier : identifiers) {
            value = response.getValue(identifier);
            CamelDecisionTableTest.assertNotNull((Object)value);
            CamelDecisionTableTest.assertIsInstanceOf(Person.class, (Object)value);
            CamelDecisionTableTest.assertTrue((boolean)((Person)value).isCanDrink());
            System.out.println(identifier + " = " + value);
        }
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext(new String[]{"META-INF/spring/camel-context-decision-table.xml", "META-INF/spring/drools-decision-table.xml"});
    }
}

