/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import org.assertj.core.api.Assertions;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.JtaTransactionManagerFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.Environment;

public class TransactionManagerFactoryTest {
    TransactionManagerFactory transactionManagerFactory = this.getTransactionManagerFactory();

    @AfterEach
    public void cleanup() {
        System.clearProperty("org.kie.txm.factory.class");
        TransactionManagerFactoryTest transactionManagerFactoryTest = this;
        transactionManagerFactoryTest.transactionManagerFactory.resetInstance();
    }

    @Test
    public void defaultsToJtaTransactionManagerFactory() throws Exception {
        TransactionManagerFactoryTest transactionManagerFactoryTest = this;
        Assertions.assertThat((boolean)(transactionManagerFactoryTest.transactionManagerFactory.get() instanceof JtaTransactionManagerFactory)).isTrue();
    }

    @Test
    public void createsSystemPropertySpecifiedFactory() throws Exception {
        System.setProperty("org.kie.txm.factory.class", TestTransactionManagerFactory.class.getName());
        TransactionManagerFactoryTest transactionManagerFactoryTest = this;
        transactionManagerFactoryTest.transactionManagerFactory.resetInstance();
        TransactionManagerFactoryTest transactionManagerFactoryTest2 = this;
        Assertions.assertThat((String)transactionManagerFactoryTest2.transactionManagerFactory.get().getClass().getName()).isEqualTo(TestTransactionManagerFactory.class.getName());
    }

    @Test
    public void createAndResetSystemPropertySpecifiedFactory() throws Exception {
        System.setProperty("org.kie.txm.factory.class", TestTransactionManagerFactory.class.getName());
        TransactionManagerFactoryTest transactionManagerFactoryTest = this;
        transactionManagerFactoryTest.transactionManagerFactory.resetInstance();
        TransactionManagerFactoryTest transactionManagerFactoryTest2 = this;
        Assertions.assertThat((String)transactionManagerFactoryTest2.transactionManagerFactory.get().getClass().getName()).isEqualTo(TestTransactionManagerFactory.class.getName());
        System.setProperty("org.kie.txm.factory.class", TestTransactionManagerFactoryTwo.class.getName());
        TransactionManagerFactoryTest transactionManagerFactoryTest3 = this;
        transactionManagerFactoryTest3.transactionManagerFactory.resetInstance();
        TransactionManagerFactoryTest transactionManagerFactoryTest4 = this;
        Assertions.assertThat((String)transactionManagerFactoryTest4.transactionManagerFactory.get().getClass().getName()).isEqualTo(TestTransactionManagerFactoryTwo.class.getName());
        TransactionManagerFactoryTest transactionManagerFactoryTest5 = this;
        transactionManagerFactoryTest5.transactionManagerFactory.resetInstance();
    }

    @Test
    public void createsJtaTransactionManager() throws Exception {
        Assertions.assertThat((String)this.transactionManagerFactory.newTransactionManager().getClass().getName()).isEqualTo(JtaTransactionManager.class.getName());
    }

    @Test
    public void createsJtaTransactionManagerWithEnvironment() throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        TransactionManagerFactoryTest transactionManagerFactoryTest = this;
        Assertions.assertThat((String)transactionManagerFactoryTest.transactionManagerFactory.get().getClass().getName()).isEqualTo(JtaTransactionManagerFactory.class.getName());
        Assertions.assertThat((Object)this.transactionManagerFactory.newTransactionManager(env)).isNotNull();
        Assertions.assertThat((String)this.transactionManagerFactory.newTransactionManager(env).getClass().getName()).isEqualTo(JtaTransactionManager.class.getName());
    }

    private TransactionManagerFactory getTransactionManagerFactory() {
        try {
            Class<?> factoryClazz = this.getClass().getClassLoader().loadClass("org.drools.persistence.api.TransactionManagerFactory");
            return (TransactionManagerFactory)factoryClazz.getMethod("get", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final class TestTransactionManagerFactory
    extends TransactionManagerFactory {
        public TransactionManager newTransactionManager() {
            return null;
        }

        public TransactionManager newTransactionManager(Environment environment) {
            return null;
        }
    }

    public static final class TestTransactionManagerFactoryTwo
    extends TransactionManagerFactory {
        public TransactionManager newTransactionManager() {
            return null;
        }

        public TransactionManager newTransactionManager(Environment environment) {
            return null;
        }
    }
}

