/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.compiler.Cheese;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MoreBatchExecutionPersistenceTest {
    private KieSession ksession = null;
    private Map<String, Object> context;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @AfterEach
    public void cleanUpPersistence() throws Exception {
        this.disposeKSession();
        DroolsPersistenceUtil.cleanUp(this.context);
        this.context = null;
    }

    public void disposeKSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    private StatefulKnowledgeSession createKnowledgeSession(String locking, KieBase kbase) {
        if (this.context == null) {
            this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        }
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)env);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testFireAllRules(String locking) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/drl/test_ImportFunctions.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession(locking, (KieBase)kbase);
        Cheese cheese = new Cheese("stilton", 15);
        this.ksession.insert((Object)cheese);
        List list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newFireAllRules((String)"fired"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Batch execution result is null!", new Object[0])).isNotNull();
        Object firedObject = result.getValue("fired");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(firedObject instanceof Integer)).as("Retrieved object is null or incorrect!", new Object[0])).isTrue();
        Assertions.assertThat((Object)firedObject).isEqualTo((Object)4);
        list = (List)this.ksession.getGlobal("list");
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"rule1");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule2");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule3");
        Assertions.assertThat(list.get(3)).isEqualTo((Object)"rule4");
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testQuery(String locking) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/simple_query_test.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession(locking, (KieBase)kbase);
        this.ksession.insert((Object)new Cheese("stinky", 5));
        this.ksession.insert((Object)new Cheese("smelly", 7));
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newQuery((String)"numStinkyCheeses", (String)"simple query"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("Batch execution result is null!", new Object[0])).isNotNull();
        Object queryResultsObject = result.getValue("numStinkyCheeses");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(queryResultsObject instanceof QueryResults)).as("Retrieved object is null or incorrect!", new Object[0])).isTrue();
        Assertions.assertThat((int)((QueryResults)queryResultsObject).size()).isEqualTo(1);
    }
}

