/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimpleBatchExecutionPersistenceTest {
    private Map<String, Object> context;
    private KieSession ksession;
    protected static final String ruleString = "package org.kie.api.persistence \nglobal String globalCheeseCountry\n\nrule 'EmptyRule' \n    when\n    then\nend\n";

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @AfterEach
    public void cleanUpPersistence() throws Exception {
        this.disposeKSession();
        DroolsPersistenceUtil.cleanUp(this.context);
        this.context = null;
    }

    private StatefulKnowledgeSession createKnowledgeSession(String locking, KieBase kbase) {
        if (this.context == null) {
            this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        }
        KieSessionConfiguration ksconf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)ksconf, (Environment)env);
    }

    private void createKSession(String locking) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession(locking, (KieBase)kbase);
    }

    @AfterEach
    public void disposeKSession() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInsertObjectCommand(String locking) throws Exception {
        this.createKSession(locking);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)expected_1, (String)"out_1"));
        commands.add(CommandFactory.newInsert((Object)expected_2, (String)"out_2"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Object fact_1 = result.getValue("out_1");
        Assertions.assertThat((Object)fact_1).isNotNull();
        Object fact_2 = result.getValue("out_2");
        Assertions.assertThat((Object)fact_2).isNotNull();
        this.ksession.fireAllRules();
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        Collection factList = this.ksession.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((factList.size() == expectedList.size() ? 1 : 0) != 0).as("Expected " + expectedList.size() + " objects but retrieved " + factList.size(), new Object[0])).isTrue();
        for (Object fact : factList) {
            expectedList.remove(fact);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expectedList.isEmpty()).as("Retrieved object list did not contain expected objects.", new Object[0])).isTrue();
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInsertElementsCommand(String locking) throws Exception {
        this.createKSession(locking);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        List<Object> factCollection = Arrays.asList(expectedArr);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsertElements(factCollection, (String)"out_list", (boolean)true, null));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Collection outList = (Collection)result.getValue("out_list");
        Assertions.assertThat((Collection)outList).isNotNull();
        this.ksession.fireAllRules();
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        Collection factList = this.ksession.getObjects();
        ((AbstractBooleanAssert)Assertions.assertThat((factList.size() == expectedList.size() ? 1 : 0) != 0).as("Expected " + expectedList.size() + " objects but retrieved " + factList.size(), new Object[0])).isTrue();
        for (Object fact : factList) {
            expectedList.remove(fact);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expectedList.isEmpty()).as("Retrieved object list did not contain expected objects.", new Object[0])).isTrue();
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testSetGlobalCommand(String locking) throws Exception {
        this.createKSession(locking);
        this.ksession.insert((Object)new Integer(5));
        this.ksession.insert((Object)new Integer(7));
        this.ksession.fireAllRules();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"globalCheeseCountry", (Object)"France", (boolean)true));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        Assertions.assertThat((Object)result).isNotNull();
        Object global = result.getValue("globalCheeseCountry");
        Assertions.assertThat((Object)global).isNotNull();
        Assertions.assertThat((Object)global).isEqualTo((Object)"France");
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testGetGlobalCommand(String locking) throws Exception {
        this.createKSession(locking);
        this.ksession.insert((Object)new Integer(5));
        this.ksession.insert((Object)new Integer(7));
        this.ksession.fireAllRules();
        this.ksession.setGlobal("globalCheeseCountry", (Object)"France");
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetGlobal((String)"globalCheeseCountry", (String)"cheeseCountry"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("GetGlobalCommand result is null!", new Object[0])).isNotNull();
        Object global = result.getValue("cheeseCountry");
        ((ObjectAssert)Assertions.assertThat((Object)global).as("Retrieved global fact is null!", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)global).as("Retrieved global is not equal to 'France'.", new Object[0])).isEqualTo((Object)"France");
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testGetObjectCommand(String locking) throws Exception {
        this.createKSession(locking);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = this.ksession.insert((Object)expected_1);
        FactHandle handle_2 = this.ksession.insert((Object)expected_2);
        this.ksession.fireAllRules();
        Object fact = this.ksession.getObject(handle_1);
        Assertions.assertThat((Object)fact).isNotNull();
        Assertions.assertThat((Object)fact).isEqualTo((Object)expected_1);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetObject((FactHandle)handle_1, (String)"out_1"));
        commands.add(CommandFactory.newGetObject((FactHandle)handle_2, (String)"out_2"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("GetObjectCommand result is null!", new Object[0])).isNotNull();
        Assertions.assertThat((Object)result.getValue("out_1")).isEqualTo((Object)expected_1);
        Assertions.assertThat((Object)result.getValue("out_2")).isEqualTo((Object)expected_2);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testGetObjectsCommand(String locking) throws Exception {
        this.createKSession(locking);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = this.ksession.insert((Object)expected_1);
        FactHandle handle_2 = this.ksession.insert((Object)expected_2);
        this.ksession.fireAllRules();
        Object object = this.ksession.getObject(handle_1);
        Assertions.assertThat((Object)object).isNotNull();
        Assertions.assertThat((Object)object).isEqualTo((Object)expected_1);
        object = this.ksession.getObject(handle_2);
        Assertions.assertThat((Object)object).isNotNull();
        Assertions.assertThat((Object)object).isEqualTo((Object)expected_2);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newGetObjects((String)"out_list"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("GetObjectsCommand result is null!", new Object[0])).isNotNull();
        List objectList = (List)result.getValue("out_list");
        ((AbstractBooleanAssert)Assertions.assertThat((objectList != null && !objectList.isEmpty() ? 1 : 0) != 0).as("Retrieved object list is null or empty!", new Object[0])).isTrue();
        Collection factList = this.ksession.getObjects();
        Object[] expectedArr = new Object[]{expected_1, expected_2};
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expectedArr));
        ((AbstractBooleanAssert)Assertions.assertThat((factList.size() == expectedList.size() ? 1 : 0) != 0).as("Expected " + expectedList.size() + " objects but retrieved " + factList.size(), new Object[0])).isTrue();
        for (Object fact : factList) {
            expectedList.remove(fact);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expectedList.isEmpty()).as("Retrieved object list did not contain expected objects.", new Object[0])).isTrue();
    }
}

