/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.kie.persistence.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class PersistentSessionForallTest {
    private KieSession kieSession;
    private Map<String, Object> context;
    private Environment env;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    private void setUp(String locking) throws Exception {
        this.setupPersistence(locking);
        this.createKieSession();
    }

    private void setupPersistence(String locking) {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    private void createKieSession() {
        String drl = "import " + Person.class.getCanonicalName() + "\nimport " + Pet.class.getCanonicalName() + "\n\nimport java.util.ArrayList;\n\n// all people known as \"cat lady\" have only cats as pets\nrule \"Forall1\" when\n  forall ( $pet : Pet ( owner.name  == 'cat lady' )\n           Pet ( this == $pet, type == Pet.PetType.cat )\n    )\nthen\nend\n\n// all people known as \"dog lady\" have only dogs as pets\nrule \"Forall2\" when\n  forall ( $pet : Pet ( owner.name == 'dog lady')\n           Pet ( this == $pet, type == Pet.PetType.dog )\n  )\nthen\nend\n";
        KieBase kbase = new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
        this.kieSession = KieServices.Factory.get().getStoreServices().newKieSession(kbase, null, this.env);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanUpKieSession();
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    private void cleanUpKieSession() {
        if (this.kieSession != null) {
            this.kieSession.destroy();
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testNotMatchedCombination(String locking) throws Exception {
        this.setUp(locking);
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        this.kieSession.addEventListener((AgendaEventListener)listener);
        Person owner = new Person("dog lady");
        Pet dog = new Pet(Pet.PetType.dog, owner);
        this.kieSession.insert((Object)dog);
        this.kieSession.fireAllRules();
        Assertions.assertThat((boolean)listener.isRuleFired("Forall2")).isTrue();
    }

    public static class Pet
    implements Serializable {
        private static final long serialVersionUID = -3519777750853629395L;
        private PetType type;
        private int age;
        private Person owner;

        public Pet(PetType type) {
            this.type = type;
            this.age = 0;
        }

        public Pet(PetType type, Person owner) {
            this(type);
            this.owner = owner;
        }

        public PetType getType() {
            return this.type;
        }

        public void setType(PetType type) {
            this.type = type;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public Person getOwner() {
            return this.owner;
        }

        public void setOwner(Person owner) {
            this.owner = owner;
        }

        public static enum PetType {
            dog,
            cat;

        }
    }

    public static class TrackingAgendaEventListener
    extends DefaultAgendaEventListener {
        private Map<String, Integer> rulesFired = new HashMap<String, Integer>();

        public void afterMatchFired(AfterMatchFiredEvent event) {
            String rule = event.getMatch().getRule().getName();
            if (this.isRuleFired(rule)) {
                this.rulesFired.put(rule, this.rulesFired.get(rule) + 1);
            } else {
                this.rulesFired.put(rule, 1);
            }
        }

        public boolean isRuleFired(String rule) {
            return this.rulesFired.containsKey(rule);
        }

        public int ruleFiredCount(String rule) {
            if (this.isRuleFired(rule)) {
                return this.rulesFired.get(rule);
            }
            return 0;
        }

        public void clear() {
            this.rulesFired.clear();
        }
    }
}

