/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import org.assertj.core.api.Assertions;
import org.drools.commands.ChainableRunner;
import org.drools.commands.impl.CommandBasedStatefulKnowledgeSessionImpl;
import org.drools.commands.impl.FireAllRulesInterceptor;
import org.drools.commands.impl.LoggingInterceptor;
import org.drools.core.FlowSessionConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.KieHelper;

public class JpaPersistentStatefulSessionTest {
    private Map<String, Object> context;
    private Environment env;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.env = DroolsPersistenceUtil.createEnvironment(this.context);
    }

    private void setLocking(String locking) {
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testFactHandleSerialization(String locking) {
        this.setLocking(locking);
        this.factHandleSerialization(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testFactHandleSerializationWithOOPath(String locking) {
        this.setLocking(locking);
        this.factHandleSerialization(true);
    }

    private void factHandleSerialization(boolean withOOPath) {
        String str = "package org.kie.test\nimport java.util.concurrent.atomic.AtomicInteger\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? " AtomicInteger($i: /intValue[this > 0])\n" : " $i: AtomicInteger(intValue > 0)\n") + "then\n list.add( $i );\nend\n\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(2);
        String externalForm = atomicFH.toExternalForm();
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        Assertions.assertThat(list).hasSize(3);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testLocalTransactionPerStatement(String locking) {
        this.setLocking(locking);
        this.localTransactionPerStatement(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testLocalTransactionPerStatementWithOOPath(String locking) {
        this.setLocking(locking);
        this.localTransactionPerStatement(true);
    }

    private void localTransactionPerStatement(boolean withOOPath) {
        String rule = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(rule, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testUserTransactions(String locking) throws Exception {
        this.setLocking(locking);
        this.userTransactions(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testUserTransactionsWithOOPath() throws Exception {
        this.userTransactions(true);
    }

    private void userTransactions(boolean withOOPath) throws Exception {
        String str = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? " $i: Integer( /intValue[this > 0])\n" : " $i : Integer(intValue > 0)\n") + "then\n list.add( $i );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        Assertions.assertThat(list).hasSize(2);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 3, 4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 5, 6);
        ut.rollback();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(4);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        this.insertIntRange(ksession, 7, 8);
        ut.commit();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(6);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInterceptor() {
        this.interceptor(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInterceptorWithOOPath() {
        this.interceptor(true);
    }

    private void interceptor(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSessionImpl)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        Assertions.assertThat(list).hasSize(3);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInterceptorOnRollback() throws Exception {
        this.interceptorOnRollback(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInterceptorOnRollbackWithOOPAth() throws Exception {
        this.interceptorOnRollback(true);
    }

    private void interceptorOnRollback(boolean withOOPath) throws Exception {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        PersistableRunner sscs = (PersistableRunner)((CommandBasedStatefulKnowledgeSessionImpl)ksession).getRunner();
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        sscs.addInterceptor((ChainableRunner)new FireAllRulesInterceptor());
        sscs.addInterceptor((ChainableRunner)new LoggingInterceptor());
        ChainableRunner runner = sscs.getChainableRunner();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(FireAllRulesInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        ut.begin();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ut.rollback();
        ksession.insert((Object)3);
        runner = sscs.getChainableRunner();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(FireAllRulesInterceptor.class);
        runner = (ChainableRunner)runner.getNext();
        Assertions.assertThat(runner.getClass()).isEqualTo(LoggingInterceptor.class);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testSetFocus() {
        this.testFocus(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testSetFocusWithOOPath() {
        this.testFocus(true);
    }

    private void testFocus(boolean withOOPath) {
        Object str = "package org.kie.test\nglobal java.util.List list\nrule rule1\nagenda-group \"badfocus\"when\n" + (withOOPath ? "  Integer(/intValue[this > 0])\n" : "  Integer(intValue > 0)\n") + "then\n  list.add( 1 );\nend\n\n";
        str = CommonTestMethodBase.replaceAgendaGroupIfRequired((String)str);
        KieBase kbase = new KieHelper().addContent((String)str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testSharedReferences() {
        KieBase kbase = new KieHelper().getKieContainer().getKieBase();
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        Person x = new Person("test");
        ArrayList<Person> test = new ArrayList<Person>();
        ArrayList<Person> test2 = new ArrayList<Person>();
        test.add(x);
        test2.add(x);
        Assertions.assertThat((Object)((Person)test.get(0))).isSameAs(test2.get(0));
        ksession.insert(test);
        ksession.insert(test2);
        ksession.fireAllRules();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)this.env);
        Iterator c = ksession2.getObjects().iterator();
        List ref1 = (List)c.next();
        List ref2 = (List)c.next();
        Assertions.assertThat(ref1.get(0)).isSameAs(ref2.get(0));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testMergeConfig() {
        KieBase kbase = new KieHelper().getKieContainer().getKieBase();
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "com.example.CustomJPAProcessInstanceManagerFactory");
        KieSessionConfiguration config = RuleBaseFactory.newKnowledgeSessionConfiguration((ChainedProperties)ChainedProperties.getChainedProperties(null).addProperties(properties), null);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, config, this.env);
        SessionConfiguration sessionConfig = (SessionConfiguration)ksession.getSessionConfiguration().as(SessionConfiguration.KEY);
        Assertions.assertThat((String)((FlowSessionConfiguration)sessionConfig.as(FlowSessionConfiguration.KEY)).getProcessInstanceManagerFactory()).isEqualTo("com.example.CustomJPAProcessInstanceManagerFactory");
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testCreateAndDestroySession() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.createAndDestroySession(false));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testCreateAndDestroySessionWithOOPath() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.createAndDestroySession(true));
    }

    public void createAndDestroySession(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)this.env);
        Assertions.fail((String)("There should not be any session with id " + ksessionId));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testCreateAndDestroyNonPersistentSession() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.createAndDestroyNonPersistentSession(true));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testCreateAndDestroyNonPersistentSessionWithOOPath() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.createAndDestroyNonPersistentSession(true));
    }

    private void createAndDestroyNonPersistentSession(boolean withOOPath) {
        String str = this.getSimpleRule(withOOPath);
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        this.insertIntRange(ksession, 1, 3);
        ksession.fireAllRules();
        Assertions.assertThat(list).hasSize(3);
        long ksessionId = ksession.getIdentifier();
        ksession.destroy();
        ksession.fireAllRules();
        Assertions.fail((String)("Session should already be disposed " + ksessionId));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testFromNodeWithModifiedCollection() {
        this.fromNodeWithModifiedCollection(false);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testFromNodeWithModifiedCollectionWithOOPath() {
        this.fromNodeWithModifiedCollection(true);
    }

    private void fromNodeWithModifiedCollection(boolean withOOPath) {
        String str = "package org.drools.test\nimport org.drools.mvel.compiler.Person\nimport org.drools.mvel.compiler.Address\nrule rule1\nwhen\n" + (withOOPath ? " $p: Person($list : addresses, /addresses[street == \"y\"])\n" : " $p: Person($list : addresses)\n $a: Address(street == \"y\") from $list\n") + "then\n $list.add( new Address(\"z\") );\n $list.add( new Address(\"w\") );\nend\n";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSession ksession = KieServices.get().getStoreServices().newKieSession(kbase, null, this.env);
        Person p1 = new Person("John");
        p1.addAddress(new Address("x"));
        p1.addAddress(new Address("y"));
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        Assertions.assertThat((List)p1.getAddresses()).hasSize(4);
        ksession.dispose();
    }

    private String getSimpleRule(boolean withOOPath) {
        return "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n" + (withOOPath ? "  Integer(/intValue[this > 0])\n" : "  Integer(intValue > 0)\n") + "then\n  list.add( 1 );\nend\n\n";
    }

    private void insertIntRange(KieSession ksession, int from, int to) {
        IntStream.rangeClosed(from, to).forEach(arg_0 -> ((KieSession)ksession).insert(arg_0));
    }
}

