/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.common.DefaultFactHandle;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.api.PersistenceContextManager;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ReloadSessionTest {
    private Map<String, Object> context;
    private EntityManagerFactory emf;
    private static final String ENTRY_POINT = "ep1";
    private static String simpleRule = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";
    private static final String RULE_WITH_EP = "package org.kie.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0) from entry-point ep1 \nthen\n  list.add( 1 );\nend\n\n";

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @BeforeEach
    public void setup() {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @AfterEach
    public void cleanUp() {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    private Environment createEnvironment(String locking) {
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return env;
    }

    private KieBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void reloadKnowledgeSessionTest(String locking) {
        Environment env = this.createEnvironment(locking);
        KieBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)commandKSession.getFactHandles().isEmpty()).as("There should be NO facts present in a new (empty) knowledge session.", new Object[0])).isTrue();
        Integer integerFact = new Random().nextInt(0x7FFFFFFE) + 1;
        commandKSession.insert((Object)integerFact);
        Collection factHandles = commandKSession.getFactHandles();
        ((AbstractBooleanAssert)Assertions.assertThat((!factHandles.isEmpty() ? 1 : 0) != 0).as("At least one fact should have been inserted by the ksession.insert() method above.", new Object[0])).isTrue();
        FactHandle origFactHandle = (FactHandle)factHandles.iterator().next();
        ((AbstractBooleanAssert)Assertions.assertThat((Integer.parseInt(((DefaultFactHandle)origFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0).as("The stored fact should contain the same number as the value inserted (but does not).", new Object[0])).isTrue();
        long sessionInfoId = commandKSession.getIdentifier();
        PersistenceContextManager pcm = (PersistenceContextManager)commandKSession.getEnvironment().get("org.kie.api.persistence.PersistenceContextManager");
        commandKSession.dispose();
        pcm.dispose();
        this.emf.close();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        this.context.put("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        env = this.createEnvironment(locking);
        StatefulKnowledgeSession newCommandKSession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionInfoId, (KieBase)kbase, null, (Environment)env);
        factHandles = newCommandKSession.getFactHandles();
        ((AbstractBooleanAssert)Assertions.assertThat((!factHandles.isEmpty() ? 1 : 0) != 0).as("At least one fact should have been persisted by the ksession.insert above.", new Object[0])).isTrue();
        FactHandle retrievedFactHandle = (FactHandle)factHandles.iterator().next();
        ((AbstractBooleanAssert)Assertions.assertThat((origFactHandle != retrievedFactHandle ? 1 : 0) != 0).as("If the retrieved and original FactHandle object are the same, then the knowledge session has NOT been reloaded!", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((Integer.parseInt(((DefaultFactHandle)retrievedFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0).as("The retrieved fact should contain the same info as the original (but does not).", new Object[0])).isTrue();
        ArrayList list = new ArrayList();
        newCommandKSession.setGlobal("list", list);
        newCommandKSession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    @Disabled
    public void testListenersAfterSessionReload(String locking) {
        Environment env = this.createEnvironment(locking);
        KieBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener());
        ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener());
        Assertions.assertThat((int)ksession.getRuleRuntimeEventListeners().size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getAgendaEventListeners().size()).isEqualTo(1);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksession.getIdentifier(), (KieBase)kbase, null, (Environment)env);
        Assertions.assertThat((int)ksession.getRuleRuntimeEventListeners().size()).isEqualTo(1);
        Assertions.assertThat((int)ksession.getAgendaEventListeners().size()).isEqualTo(1);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInsert(String locking) {
        Environment env = this.createEnvironment(locking);
        KieBase kbase = this.initializeKnowledgeBase(RULE_WITH_EP);
        StatefulKnowledgeSession kieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kieSession.getFactHandles().isEmpty()).as("There should be NO facts present in a new (empty) knowledge session.", new Object[0])).isTrue();
        kieSession.insert((Object)10);
        kieSession = this.reloadSession((KieSession)kieSession, env);
        Collection objects = kieSession.getObjects();
        ((AbstractIntegerAssert)Assertions.assertThat((int)objects.size()).as("Reloaded working memory should contain the fact.", new Object[0])).isEqualTo(1);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testInsertIntoEntryPoint(String locking) {
        Environment env = this.createEnvironment(locking);
        KieBase kbase = this.initializeKnowledgeBase(RULE_WITH_EP);
        StatefulKnowledgeSession kieSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kieSession.getFactHandles().isEmpty()).as("There should be NO facts present in a new (empty) knowledge session.", new Object[0])).isTrue();
        kieSession.getEntryPoint(ENTRY_POINT).insert((Object)10);
        kieSession = this.reloadSession((KieSession)kieSession, env);
        Collection objects = kieSession.getEntryPoint(ENTRY_POINT).getObjects();
        ((AbstractIntegerAssert)Assertions.assertThat((int)objects.size()).as("Reloaded working memory should contain the fact in the entry point.", new Object[0])).isEqualTo(1);
    }

    private KieSession reloadSession(KieSession kieSession, Environment environment) {
        long sessionId = kieSession.getIdentifier();
        KieBase kieBase = kieSession.getKieBase();
        kieSession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)kieBase, null, (Environment)environment);
    }
}

