/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.commands.impl.CommandBasedStatefulKnowledgeSessionImpl;
import org.drools.core.common.InternalAgenda;
import org.drools.io.ClassPathResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFlowGroupRollbackTest {
    private static Logger logger = LoggerFactory.getLogger(RuleFlowGroupRollbackTest.class);
    private Map<String, Object> context;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
    }

    @AfterEach
    public void tearDown() {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testRuleFlowGroupRollback(String locking) throws Exception {
        CommandBasedStatefulKnowledgeSessionImpl ksession = this.createSession(locking);
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        try {
            ksession.execute((Command)new ExceptionCommand());
            Assertions.fail((String)"Process must throw an exception");
        }
        catch (Exception e) {
            logger.info("The above " + RuntimeException.class.getSimpleName() + " was expected in this test.");
        }
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    private CommandBasedStatefulKnowledgeSessionImpl createSession(String locking) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflowgroup_rollback.drl"), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addPackages(kbuilder.getKnowledgePackages());
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        return (CommandBasedStatefulKnowledgeSessionImpl)JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    public class ActivateRuleFlowCommand
    implements ExecutableCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }

    public class ExceptionCommand
    implements ExecutableCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException("(Expected) exception thrown by test");
        }
    }
}

