/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.timer.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.ClockType;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.persistence.util.DroolsPersistenceUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.Option;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TimerAndCalendarTest {
    private Map<String, Object> context;

    public static Stream<String> parameters() {
        return Stream.of(DroolsPersistenceUtil.OPTIMISTIC_LOCKING, DroolsPersistenceUtil.PESSIMISTIC_LOCKING);
    }

    @BeforeEach
    public void before() throws Exception {
        this.context = DroolsPersistenceUtil.setupWithPoolingDataSource((String)"org.drools.persistence.jpa");
    }

    @AfterEach
    public void after() throws Exception {
        DroolsPersistenceUtil.cleanUp(this.context);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    @Disabled(value="beta4 phreak")
    public void testTimerRuleAfterIntReloadSession(String locking) throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = this.createSession(locking, (KieBase)kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (int:1000 500) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KiePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addPackages(kpackages);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1700L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((int)list.size()).isEqualTo(4);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    @Disabled(value="beta4 phreak")
    public void testTimerRuleAfterCronReloadSession(String locking) throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ksession = this.createSession(locking, (KieBase)kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (cron: * * * * * ?) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KiePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addPackages(kpackages);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        ksession.setGlobal("list", list);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(2L, TimeUnit.SECONDS);
        Assertions.assertThat((int)list.size()).isEqualTo(6);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testEventExpires(String locking) throws Exception {
        String timerRule = "package org.drools.test\ndeclare TestEvent \n    @role( event )\n    @expires( 10s )\nend\nrule TimerRule \n    when \n        TestEvent( ) from entry-point \"Test\"\n    then \nend";
        KieBaseConfiguration kbconf = RuleBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((Option)EventProcessingOption.STREAM);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KiePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addPackages(kpackages);
        KieSession ksession = this.createSession(locking, (KieBase)kbase);
        FactType type = kbase.getFactType("org.drools.test", "TestEvent");
        ((ObjectAssert)Assertions.assertThat((Object)type).as("could not get type", new Object[0])).isNotNull();
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.getEntryPoint("Test").insert(type.newInstance());
        ksession.fireAllRules();
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    public void testTimerWithRemovingRule() throws Exception {
        InternalKnowledgeBase kbase1 = KnowledgeBaseFactory.newKnowledgeBase();
        String str1 = "package org.test; import java.util.*; global java.util.List list; rule R1\n    timer ( int: 5s )\nwhen\n    $s : String( )\nthen\n    list.add( $s );\nend\n";
        Resource resource1 = ResourceFactory.newByteArrayResource((byte[])str1.getBytes());
        Collection<KiePackage> kpackages1 = this.buildKnowledgePackage(resource1, ResourceType.DRL);
        kbase1.addPackages(kpackages1);
        StatefulKnowledgeSession ksession1 = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase1, null, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
        long ksessionId = ksession1.getIdentifier();
        ArrayList list = new ArrayList();
        ksession1.setGlobal("list", list);
        ksession1.insert((Object)"hello");
        ksession1.fireAllRules();
        ksession1.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        Thread.sleep(5000L);
        InternalKnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase();
        String str2 = "package org.test; import java.util.*; global java.util.List list; rule R2\nwhen\n    $s : Integer( )\nthen\n    list.add( $s );\nend\n";
        Resource resource2 = ResourceFactory.newByteArrayResource((byte[])str2.getBytes());
        Collection<KiePackage> kpackages2 = this.buildKnowledgePackage(resource2, ResourceType.DRL);
        kbase2.addPackages(kpackages2);
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase2, null, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
        ksession2.setGlobal("list", list);
        ksession2.fireAllRules();
        ksession2.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
    }

    private KieSession createSession(String locking, KieBase kbase) {
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        Environment env = DroolsPersistenceUtil.createEnvironment(this.context);
        if (DroolsPersistenceUtil.PESSIMISTIC_LOCKING.equals(locking)) {
            env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)conf, (Environment)env);
        return ksession;
    }

    private KieSession disposeAndReloadSession(KieSession ksession, KieBase kbase) {
        long ksessionId = ksession.getIdentifier();
        ksession.dispose();
        KieSessionConfiguration conf = RuleBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((Option)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession newksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, (KieSessionConfiguration)conf, (Environment)DroolsPersistenceUtil.createEnvironment(this.context));
        return newksession;
    }

    private Collection<KiePackage> buildKnowledgePackage(Resource resource, ResourceType resourceType) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, resourceType);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println("Error: " + error.getMessage());
            }
            Assertions.fail((String)"KnowledgeBase did not build");
        }
        Collection packages = kbuilder.getKnowledgePackages();
        return packages;
    }
}

