/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ClassPathResource;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.session.TestWorkItemHandler;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;

public class PersistentStatefulSessionTest
extends TestCase {
    PoolingDataSource ds1;

    protected void setUp() throws Exception {
        this.ds1 = new PoolingDataSource();
        this.ds1.setUniqueName("jdbc/testDS1");
        this.ds1.setClassName("org.h2.jdbcx.JdbcDataSource");
        this.ds1.setMaxPoolSize(3);
        this.ds1.setAllowLocalTransactions(true);
        this.ds1.getDriverProperties().put("user", "sa");
        this.ds1.getDriverProperties().put("password", "sasa");
        this.ds1.getDriverProperties().put("URL", "jdbc:h2:mem:mydb");
        this.ds1.init();
    }

    protected void tearDown() throws Exception {
        this.ds1.close();
    }

    public void testLocalTransactionPerStatement() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            PersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.persistence.jpa.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        PersistentStatefulSessionTest.assertEquals((int)3, (int)list.size());
    }

    public void testUserTransactions() throws Exception {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            PersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.persistence.jpa.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        ArrayList list = new ArrayList();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ksession.fireAllRules();
        PersistentStatefulSessionTest.assertEquals((int)2, (int)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        PersistentStatefulSessionTest.assertEquals((int)4, (int)list.size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksession.getId(), (KnowledgeBase)kbase, null, (Environment)env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        PersistentStatefulSessionTest.assertEquals((int)6, (int)list.size());
    }

    public void testPersistenceWorkItems() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("WorkItemsProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("org.drools.test.TestProcess");
        ksession.insert((Object)"TestString");
        System.out.println("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertEquals((int)1, (int)ksession.getObjects().size());
        for (Object o : ksession.getObjects()) {
            System.out.println(o);
        }
        PersistentStatefulSessionTest.assertNull((Object)processInstance);
    }

    public void testPersistenceSubProcess() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("SuperProcess.rf"), ResourceType.DRF);
        kbuilder.add((Resource)new ClassPathResource("SubProcess.rf"), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        int id = ksession.getId();
        ProcessInstance processInstance = ksession.startProcess("com.sample.SuperProcess");
        System.out.println("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNotNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNotNull((Object)processInstance);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        PersistentStatefulSessionTest.assertNull((Object)workItem);
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)env);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        PersistentStatefulSessionTest.assertNull((Object)processInstance);
    }
}

