/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.ProcessBuilder;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.persistence.session.SingleSessionCommandService;
import org.drools.persistence.session.TestWorkItemHandler;
import org.drools.process.command.Command;
import org.drools.process.command.CompleteWorkItemCommand;
import org.drools.process.command.GetProcessInstanceCommand;
import org.drools.process.command.StartProcessCommand;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.process.core.timer.Timer;
import org.drools.rule.Package;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.TimerNode;
import org.drools.workflow.core.node.WorkItemNode;
import org.drools.workflow.instance.node.SubProcessNodeInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleSessionCommandServiceTest
extends TestCase {
    PoolingDataSource ds1;
    private EntityManagerFactory emf;

    protected void setUp() {
        this.ds1 = new PoolingDataSource();
        this.ds1.setUniqueName("jdbc/testDS1");
        this.ds1.setClassName("org.h2.jdbcx.JdbcDataSource");
        this.ds1.setMaxPoolSize(3);
        this.ds1.setAllowLocalTransactions(true);
        this.ds1.getDriverProperties().put("user", "sa");
        this.ds1.getDriverProperties().put("password", "sasa");
        this.ds1.getDriverProperties().put("URL", "jdbc:h2:mem:mydb");
        this.ds1.init();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
    }

    protected void tearDown() {
        this.emf.close();
        this.ds1.close();
    }

    public void testPersistenceWorkItems() throws Exception {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", "org.drools.persistence.session.SingleSessionCommandService");
        properties.setProperty("drools.processInstanceManagerFactory", "org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.setProperty("drools.workItemManagerFactory", "org.drools.persistence.processinstance.JPAWorkItemManagerFactory");
        properties.setProperty("drools.processSignalManagerFactory", "org.drools.persistence.processinstance.JPASignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KnowledgeSessionConfiguration)config, env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection<KnowledgePackage> kpkgs = this.getProcessWorkItems();
        kbase.addKnowledgePackages(kpkgs);
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", "org.drools.persistence.session.SingleSessionCommandService");
        properties.setProperty("drools.processInstanceManagerFactory", "org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.setProperty("drools.workItemManagerFactory", "org.drools.persistence.processinstance.JPAWorkItemManagerFactory");
        properties.setProperty("drools.processSignalManagerFactory", "org.drools.persistence.processinstance.JPASignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KnowledgeSessionConfiguration)config, env);
        int sessionId = service.getSessionId();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        ut.commit();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        ut.commit();
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        ut.commit();
        workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        ut.begin();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        ut.commit();
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    private Collection<KnowledgePackage> getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }

    public void testPersistenceSubProcess() {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", "org.drools.persistence.session.SingleSessionCommandService");
        properties.setProperty("drools.processInstanceManagerFactory", "org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.setProperty("drools.workItemManagerFactory", "org.drools.persistence.processinstance.JPAWorkItemManagerFactory");
        properties.setProperty("drools.processSignalManagerFactory", "org.drools.persistence.processinstance.JPASignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = this.getProcessSubProcess();
        ruleBase.addPackage(pkg);
        SingleSessionCommandService service = new SingleSessionCommandService(ruleBase, config, env);
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        SingleSessionCommandServiceTest.assertNotNull((Object)workItem);
        service.dispose();
        service = new SingleSessionCommandService(ruleBase, config, env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        SingleSessionCommandServiceTest.assertEquals((int)1, (int)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = new SingleSessionCommandService(ruleBase, config, env);
        CompleteWorkItemCommand completeWorkItemCommand = new CompleteWorkItemCommand();
        completeWorkItemCommand.setWorkItemId(workItem.getId());
        service.execute((Command)completeWorkItemCommand);
        service.dispose();
        service = new SingleSessionCommandService(ruleBase, config, env);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(subProcessInstanceId));
        subProcessInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)subProcessInstance);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstanceId));
        processInstance = (RuleFlowProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
        service.dispose();
    }

    private Package getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    public void testPersistenceTimer() throws Exception {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", "org.drools.persistence.session.SingleSessionCommandService");
        properties.setProperty("drools.processInstanceManagerFactory", "org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.setProperty("drools.workItemManagerFactory", "org.drools.persistence.processinstance.JPAWorkItemManagerFactory");
        properties.setProperty("drools.processSignalManagerFactory", "org.drools.persistence.processinstance.JPASignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KnowledgeSessionConfiguration)config, env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNotNull((Object)processInstance);
        service.dispose();
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        Thread.sleep(3000L);
        getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay(2000L);
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }

    public void testPersistenceTimer2() throws Exception {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        Properties properties = new Properties();
        properties.setProperty("drools.commandService", "org.drools.persistence.session.SingleSessionCommandService");
        properties.setProperty("drools.processInstanceManagerFactory", "org.drools.persistence.processinstance.JPAProcessInstanceManagerFactory");
        properties.setProperty("drools.workItemManagerFactory", "org.drools.persistence.processinstance.JPAWorkItemManagerFactory");
        properties.setProperty("drools.processSignalManagerFactory", "org.drools.persistence.processinstance.JPASignalManagerFactory");
        SessionConfiguration config = new SessionConfiguration(properties);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        List<KnowledgePackage> kpkgs = this.getProcessTimer2();
        kbase.addKnowledgePackages(kpkgs);
        SingleSessionCommandService service = new SingleSessionCommandService(kbase, (KnowledgeSessionConfiguration)config, env);
        int sessionId = service.getSessionId();
        StartProcessCommand startProcessCommand = new StartProcessCommand();
        startProcessCommand.setProcessId("org.drools.test.TestProcess");
        ProcessInstance processInstance = (ProcessInstance)service.execute((Command)startProcessCommand);
        System.out.println("Started process instance " + processInstance.getId());
        Thread.sleep(2000L);
        service = new SingleSessionCommandService(sessionId, kbase, (KnowledgeSessionConfiguration)config, env);
        GetProcessInstanceCommand getProcessInstanceCommand = new GetProcessInstanceCommand();
        getProcessInstanceCommand.setProcessInstanceId(Long.valueOf(processInstance.getId()));
        processInstance = (ProcessInstance)service.execute((Command)getProcessInstanceCommand);
        SingleSessionCommandServiceTest.assertNull((Object)processInstance);
    }

    private List<KnowledgePackage> getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay(0L);
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try { Thread.sleep(1000); } catch (Throwable t) {} System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>();
        list.add((KnowledgePackage)new KnowledgePackageImp(packageBuilder.getPackage()));
        return list;
    }
}

