/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRollbackException;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.io.ResourceFactory;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jpa.JpaPersistenceContextManager;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.TransactionTestCommand;
import org.drools.persistence.jta.TransactionTestObject;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionManagerTest {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private static String simpleRule = "package org.drools.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static String COMMAND_ENTITY_MANAGER = "drools.persistence.test.command.EntityManager";
    public static String COMMAND_ENTITY_MANAGER_FACTORY = "drools.persistence.test.EntityManagerFactory";

    @Before
    public void setup() {
        this.ds1 = PersistenceUtil.setupPoolingDataSource();
        this.ds1.init();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
    }

    private Environment initializeEnvironment(EntityManagerFactory emf) {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }

    private KnowledgeBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            this.logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    @After
    public void cleanUp() {
        this.emf.close();
        this.ds1.close();
    }

    private String getTestName() {
        Object testName = null;
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String methodName = ste[2].getMethodName();
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    @Test
    public void showingTransactionTestObjectsNeedTransactions() throws Exception {
        boolean rollBackExceptionthrown;
        UserTransaction tx;
        EntityManager em;
        TransactionTestObject subObject;
        String testName;
        block4: {
            testName = this.getTestName();
            TransactionTestObject badMainObject = new TransactionTestObject();
            badMainObject.setName("bad" + testName);
            subObject = new TransactionTestObject();
            subObject.setName("sub" + testName);
            badMainObject.setSubObject(subObject);
            em = this.emf.createEntityManager();
            em.setFlushMode(FlushModeType.COMMIT);
            tx = this.findUserTransaction();
            tx.begin();
            em.joinTransaction();
            em.persist((Object)badMainObject);
            rollBackExceptionthrown = false;
            try {
                tx.commit();
            }
            catch (Exception e) {
                if (!(e instanceof BitronixRollbackException)) break block4;
                rollBackExceptionthrown = true;
            }
        }
        junit.framework.Assert.assertTrue((String)"A rollback exception should have been thrown because of foreign key violations.", (boolean)rollBackExceptionthrown);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main" + testName);
        mainObject.setSubObject(subObject);
        tx.begin();
        em.joinTransaction();
        em.persist((Object)mainObject);
        em.persist((Object)subObject);
        try {
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("No exception should have been thrown: " + e.getMessage()));
        }
    }

    @Test
    public void basicTransactionManagerTest() {
        String testName = this.getTestName();
        Environment env = this.initializeEnvironment(this.emf);
        Object tm = env.get("drools.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("drools.transaction.Transaction"), env.get("drools.transaction.TransactionSynchronizationRegistry"), tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main" + testName);
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub" + testName);
        mainObject.setSubObject(subObject);
        EntityManager em = this.emf.createEntityManager();
        try {
            boolean txOwner = txm.begin();
            boolean notTxOwner = txm.begin();
            em.persist((Object)mainObject);
            txm.commit(notTxOwner);
            em.persist((Object)subObject);
            txm.commit(txOwner);
        }
        catch (Throwable t) {
            Assert.fail((String)("No exception should have been thrown: " + t.getMessage()));
        }
    }

    @Test
    public void basicTransactionRollbackTest() {
        Environment env = this.initializeEnvironment(this.emf);
        Object tm = env.get("drools.transaction.TransactionManager");
        JtaTransactionManager txm = new JtaTransactionManager(env.get("drools.transaction.Transaction"), env.get("drools.transaction.TransactionSynchronizationRegistry"), tm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("main");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("sub");
        mainObject.setSubObject(subObject);
        EntityManager em = this.emf.createEntityManager();
        try {
            boolean txOwner = txm.begin();
            boolean notTxOwner = txm.begin();
            em.persist((Object)mainObject);
            txm.rollback(notTxOwner);
            em.persist((Object)subObject);
            txm.rollback(txOwner);
        }
        catch (Exception e) {
            Assert.fail((String)("There should not be an exception thrown here: " + e.getMessage()));
        }
    }

    @Test
    public void testSingleSessionCommandServiceAndJtaTransactionManagerTogether() {
        Environment env = this.initializeEnvironment(this.emf);
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)commandKSession).getCommandService();
        JpaPersistenceContextManager jpm = (JpaPersistenceContextManager)PersistenceUtil.getValueOfField("jpm", commandService);
        jpm.getApplicationScopedPersistenceContext();
        EntityManager em = (EntityManager)PersistenceUtil.getValueOfField("appScopedEntityManager", jpm);
        TransactionTestObject mainObject = new TransactionTestObject();
        mainObject.setName("mainCommand");
        TransactionTestObject subObject = new TransactionTestObject();
        subObject.setName("subCommand");
        mainObject.setSubObject(subObject);
        HashMap<String, Object> emEnv = new HashMap<String, Object>();
        emEnv.put(COMMAND_ENTITY_MANAGER_FACTORY, this.emf);
        emEnv.put(COMMAND_ENTITY_MANAGER, em);
        TransactionTestCommand txTestCmd = new TransactionTestCommand(mainObject, subObject, emEnv);
        commandKSession.execute((Command)txTestCmd);
    }
}

