/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.map.impl;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.map.impl.MapPersistenceTest;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaBasedPersistenceTest
extends MapPersistenceTest {
    private static Logger logger = LoggerFactory.getLogger(JPAPlaceholderResolverStrategy.class);
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private JtaTransactionManager txm;
    private boolean useTransactions = false;

    @Before
    public void setUp() throws Exception {
        this.ds1 = PersistenceUtil.setupPoolingDataSource();
        this.ds1.init();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        if (PersistenceUtil.useTransactions()) {
            this.useTransactions = true;
            Environment env = this.createEnvironment();
            Object tm = env.get("drools.transaction.TransactionManager");
            this.txm = new JtaTransactionManager(env.get("drools.transaction.Transaction"), env.get("drools.transaction.TransactionSynchronizationRegistry"), tm);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.emf.close();
        this.ds1.close();
    }

    protected StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        return JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.createEnvironment());
    }

    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase) {
        int ksessionId = ksession.getId();
        ksession.dispose();
        return JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KnowledgeBase)kbase, null, (Environment)this.createEnvironment());
    }

    protected long getSavedSessionsCount() {
        logger.info("quering number of saved sessions.");
        boolean transactionOwner = false;
        if (this.useTransactions) {
            transactionOwner = this.txm.begin();
        }
        long savedSessionsCount = this.emf.createEntityManager().createQuery("FROM SessionInfo").getResultList().size();
        if (this.useTransactions) {
            this.txm.commit(transactionOwner);
        }
        return savedSessionsCount;
    }

    private Environment createEnvironment() {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        return env;
    }
}

