/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.CommandFactory;
import org.drools.command.Interceptor;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.FireAllRulesInterceptor;
import org.drools.command.impl.LoggingInterceptor;
import org.drools.io.ResourceFactory;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPersistentStatefulSessionTest
extends TestCase {
    private static Logger logger = LoggerFactory.getLogger(JpaPersistentStatefulSessionTest.class);
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private Environment env;

    protected void setUp() throws Exception {
        this.ds1 = PersistenceUtil.setupPoolingDataSource();
        this.ds1.init();
        this.env = KnowledgeBaseFactory.newEnvironment();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        this.env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        this.env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        this.env.set("drools.Globals", (Object)new MapGlobalResolver());
    }

    protected void tearDown() throws Exception {
        this.ds1.close();
        this.emf.close();
    }

    public void testFactHandleSerialization() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "import java.util.concurrent.atomic.AtomicInteger\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + " $i: AtomicInteger(intValue > 0)\n";
        str = str + "then\n";
        str = str + " list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            JpaPersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        List list = new ArrayList();
        ksession.setGlobal("list", list);
        AtomicInteger value = new AtomicInteger(4);
        FactHandle atomicFH = ksession.insert((Object)value);
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)1, (int)list.size());
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)2, (int)list.size());
        String externalForm = atomicFH.toExternalForm();
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksession.getId(), (KnowledgeBase)kbase, null, (Environment)this.env);
        atomicFH = (FactHandle)ksession.execute(CommandFactory.fromExternalFactHandleCommand((String)externalForm));
        value.addAndGet(1);
        ksession.update(atomicFH, (Object)value);
        ksession.fireAllRules();
        list = (List)ksession.getGlobal("list");
        JpaPersistentStatefulSessionTest.assertEquals((int)3, (int)list.size());
    }

    public void testLocalTransactionPerStatement() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            JpaPersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)3, (int)list.size());
    }

    public void testUserTransactions() throws Exception {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  $i : Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( $i );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            JpaPersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ut.commit();
        ArrayList list = new ArrayList();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ut.rollback();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.fireAllRules();
        ut.commit();
        JpaPersistentStatefulSessionTest.assertEquals((int)2, (int)list.size());
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)3);
        ksession.insert((Object)4);
        ut.commit();
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ut.rollback();
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)4, (int)list.size());
        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksession.getId(), (KnowledgeBase)kbase, null, (Environment)this.env);
        ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ksession.insert((Object)7);
        ksession.insert((Object)8);
        ut.commit();
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)6, (int)list.size());
    }

    public void testInterceptor() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            JpaPersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        SingleSessionCommandService sscs = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
        sscs.addInterceptor((Interceptor)new LoggingInterceptor());
        sscs.addInterceptor((Interceptor)new FireAllRulesInterceptor());
        sscs.addInterceptor((Interceptor)new LoggingInterceptor());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getWorkItemManager().completeWorkItem(0L, null);
        JpaPersistentStatefulSessionTest.assertEquals((int)3, (int)list.size());
    }

    public void testSetFocus() {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1\n";
        str = str + "agenda-group \"badfocus\"";
        str = str + "when\n";
        str = str + "  Integer(intValue > 0)\n";
        str = str + "then\n";
        str = str + "  list.add( 1 );\n";
        str = str + "end\n";
        str = str + "\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            JpaPersistentStatefulSessionTest.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.insert((Object)3);
        ksession.getAgenda().getAgendaGroup("badfocus").setFocus();
        ksession.fireAllRules();
        JpaPersistentStatefulSessionTest.assertEquals((int)3, (int)list.size());
    }
}

