/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.DefaultFactHandle;
import org.drools.io.ResourceFactory;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReloadSessionTest {
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private static String simpleRule = "package org.drools.test\nglobal java.util.List list\nrule rule1\nwhen\n  Integer(intValue > 0)\nthen\n  list.add( 1 );\nend\n\n";

    @Before
    public void setup() {
        this.ds1 = PersistenceUtil.setupPoolingDataSource();
        this.ds1.init();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
    }

    @After
    public void cleanUp() {
        this.emf.close();
        this.ds1.close();
    }

    private KnowledgeBase initializeKnowledgeBase(String rule) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private Environment initializeEnvironment(EntityManagerFactory emf) {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }

    @Test
    public void reloadKnowledgeSessionTest() {
        Environment env = this.initializeEnvironment(this.emf);
        KnowledgeBase kbase = this.initializeKnowledgeBase(simpleRule);
        StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
        Assert.assertTrue((String)"There should be NO facts present in a new (empty) knowledge session.", (boolean)commandKSession.getFactHandles().isEmpty());
        Integer integerFact = new Random().nextInt(0x7FFFFFFE) + 1;
        commandKSession.insert((Object)integerFact);
        Collection factHandles = commandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been inserted by the ksession.insert() method above.", (!factHandles.isEmpty() ? 1 : 0) != 0);
        FactHandle origFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"The stored fact should contain the same number as the value inserted (but does not).", (Integer.parseInt(((DefaultFactHandle)origFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        int sessionInfoId = commandKSession.getId();
        PersistenceContextManager pcm = (PersistenceContextManager)commandKSession.getEnvironment().get("drools.persistence.PersistenceContextManager");
        commandKSession.dispose();
        pcm.dispose();
        this.emf.close();
        this.emf = Persistence.createEntityManagerFactory((String)"org.drools.persistence.jpa");
        env = this.initializeEnvironment(this.emf);
        StatefulKnowledgeSession newCommandKSession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionInfoId, (KnowledgeBase)kbase, null, (Environment)env);
        factHandles = newCommandKSession.getFactHandles();
        Assert.assertTrue((String)"At least one fact should have been persisted by the ksession.insert above.", (!factHandles.isEmpty() && factHandles.size() == 1 ? 1 : 0) != 0);
        FactHandle retrievedFactHandle = (FactHandle)factHandles.iterator().next();
        Assert.assertTrue((String)"If the retrieved and original FactHandle object are the same, then the knowledge session has NOT been reloaded!", (origFactHandle != retrievedFactHandle ? 1 : 0) != 0);
        Assert.assertTrue((String)"The retrieved fact should contain the same info as the original (but does not).", (Integer.parseInt(((DefaultFactHandle)retrievedFactHandle).getObject().toString()) == integerFact ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        newCommandKSession.setGlobal("list", list);
        newCommandKSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }
}

