/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.impl.EnvironmentFactory;
import org.drools.marshalling.util.CompareViaReflectionUtil;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingDBUtil;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.time.impl.TrackableTimeJobFactoryManager;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestMarshallingUtilsTest {
    private static boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testUnmarshallingMarshalledData() {
        HashMap<String, Object> testContext = null;
        ArrayList<MarshalledData> marshalledDataList = null;
        try {
            testContext = MarshallingDBUtil.initializeMarshalledDataEMF("org.drools.persistence.jpa", this.getClass(), true);
            EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
            marshalledDataList = MarshallingTestUtil.retrieveMarshallingData(emf);
        }
        finally {
            PersistenceUtil.tearDown(testContext);
        }
        for (MarshalledData marshalledData : marshalledDataList) {
            String className = marshalledData.marshalledObjectClassName.substring(marshalledData.marshalledObjectClassName.lastIndexOf(46) + 1);
            try {
                MarshallingTestUtil.unmarshallObject(marshalledData);
                System.out.println("- " + className + ": " + marshalledData.getTestMethodAndSnapshotNum());
            }
            catch (Exception e) {
                System.out.println("X " + className + ": " + marshalledData.getTestMethodAndSnapshotNum());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testUnmarshallingSpecificMarshalledData() {
        String testMethodAndSnapNum = "org.drools.persistence.session.RuleFlowGroupRollbackTest.testRuleFlowGroupRollback:1";
        HashMap<String, Object> testContext = MarshallingDBUtil.initializeMarshalledDataEMF("org.drools.persistence.jpa", this.getClass(), true);
        EntityManagerFactory emf = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
        ArrayList<MarshalledData> marshalledDataList = MarshallingTestUtil.retrieveMarshallingData(emf);
        MarshalledData marshalledData = null;
        for (MarshalledData marshalledDataElement : marshalledDataList) {
            if (!testMethodAndSnapNum.equals(marshalledDataElement.getTestMethodAndSnapshotNum())) continue;
            marshalledData = marshalledDataElement;
        }
        try {
            Object unmarshalledObject = MarshallingTestUtil.unmarshallObject(marshalledData);
            Assert.assertNotNull((Object)unmarshalledObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("[" + e.getClass().getSimpleName() + "]: " + e.getMessage()));
        }
        finally {
            PersistenceUtil.tearDown(testContext);
        }
    }

    @Test
    public void testCompareArrays() {
        int[] testA = new int[]{1, 3};
        int[] testB = new int[]{1, 3};
        boolean same = CompareViaReflectionUtil.compareInstances(testA, testA);
        Assert.assertTrue((boolean)same);
        TestMarshallingUtilsTest.printResult(same, testA, testB);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBase[] testArrA = new KnowledgeBase[]{kbase};
        KnowledgeBase[] testArrB = new KnowledgeBase[]{kbase, null};
        same = CompareViaReflectionUtil.compareInstances(testArrA, testArrB);
        Assert.assertTrue((!same ? 1 : 0) != 0);
        TestMarshallingUtilsTest.printResult(same, testArrA, testArrB);
        Environment[] testEnvA = new Environment[]{EnvironmentFactory.newEnvironment(), EnvironmentFactory.newEnvironment()};
        Environment[] testEnvB = new Environment[]{EnvironmentFactory.newEnvironment(), EnvironmentFactory.newEnvironment()};
        testEnvA[0].set("org.drools.persistence.jpa", (Object)"org.drools.persistence.jpa");
        same = CompareViaReflectionUtil.compareInstances(testEnvA, testEnvB);
        Assert.assertTrue((!same ? 1 : 0) != 0);
        TestMarshallingUtilsTest.printResult(same, testEnvA, testEnvB);
    }

    private static void printResult(boolean same, Object objA, Object objB) {
        int i;
        if (!debug) {
            return;
        }
        System.out.println("Same: " + same);
        String outLine = "a: {";
        for (i = 0; i < Array.getLength(objA); ++i) {
            outLine = outLine + Array.get(objA, i) + ",";
        }
        outLine = outLine.substring(0, outLine.lastIndexOf(",")) + "}";
        System.out.println(outLine);
        outLine = "b: {";
        for (i = 0; i < Array.getLength(objB); ++i) {
            outLine = outLine + Array.get(objB, i) + ",";
        }
        outLine = outLine.substring(0, outLine.lastIndexOf(",")) + "}";
        System.out.println(outLine);
    }

    @Test
    public void testCompareInstances() throws Exception {
        StatefulKnowledgeSession ksessionA = null;
        KnowledgeBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBaseA = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
        KnowledgeSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ((SessionConfiguration)ksconf).setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        ksessionA = knowledgeBaseA.newStatefulKnowledgeSession(ksconf, null);
        StatefulKnowledgeSession ksessionB = null;
        KnowledgeBaseConfiguration config2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config2.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config2);
        KnowledgeSessionConfiguration ksconf2 = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf2.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ((SessionConfiguration)ksconf2).setTimerJobFactoryManager((TimerJobFactoryManager)new TrackableTimeJobFactoryManager());
        ksessionB = knowledgeBase.newStatefulKnowledgeSession(ksconf2, null);
        Assert.assertTrue((String)(CompareViaReflectionUtil.class.getSimpleName() + " is broken!"), (boolean)CompareViaReflectionUtil.compareInstances(ksessionA, ksessionB));
    }
}

