/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.io.Resource;
import org.drools.io.impl.ClassPathResource;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.impl.InternalAgenda;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleFlowGroupRollbackTest {
    private HashMap<String, Object> context;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
    }

    @After
    public void tearDown() {
        PersistenceUtil.tearDown(this.context);
    }

    @Test
    public void testRuleFlowGroupRollback() throws Exception {
        CommandBasedStatefulKnowledgeSession ksession = this.createSession();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Test");
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        try {
            ksession.execute((Command)new ExceptionCommand());
            Assert.fail((String)"Process must throw an exception");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ksession.insert(list);
        ksession.execute((Command)new ActivateRuleFlowCommand("ruleflow-group"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    private CommandBasedStatefulKnowledgeSession createSession() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ClassPathResource("ruleflowgroup_rollback.drl"), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Environment env = PersistenceUtil.createEnvironment(this.context);
        return (CommandBasedStatefulKnowledgeSession)JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExceptionCommand
    implements GenericCommand<Object> {
        public Void execute(Context context) {
            throw new RuntimeException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ActivateRuleFlowCommand
    implements GenericCommand<Object> {
        private String ruleFlowGroupName;

        public ActivateRuleFlowCommand(String ruleFlowGroupName) {
            this.ruleFlowGroupName = ruleFlowGroupName;
        }

        public Void execute(Context context) {
            StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup(this.ruleFlowGroupName);
            return null;
        }
    }
}

