/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.StringUtils;
import org.drools.impl.EnvironmentFactory;
import org.drools.marshalling.Marshaller;
import org.drools.marshalling.MarshallerFactory;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.util.CompareViaReflectionUtil;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingDBUtil;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.process.instance.WorkItem;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.time.impl.DefaultTimerJobInstance;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingTestUtil {
    private static Logger logger = LoggerFactory.getLogger(MarshallingTestUtil.class);
    protected static boolean STORE_KNOWLEDGE_BASE = false;
    protected static final String PROCESS_INSTANCE_INFO_CLASS_NAME = "org.jbpm.persistence.processinstance.ProcessInstanceInfo";
    private static final String PROCESS_INSTANCE_MARSHALL_UTIL_CLASS_NAME = "org.jbpm.marshalling.util.MarshallingTestUtil";
    private static final String PROCESS_INSTANCE_RESOLVER_STRATEGY = "org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy";
    private static MessageDigest algorithm = null;

    public static void compareMarshallingDataFromTest(String persistenceUnitName) {
        Class<?> testClass = null;
        try {
            testClass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to retrieve class of test running: [" + e.getClass().getSimpleName() + "] " + e.getMessage()));
        }
        MarshallingTestUtil.compareMarshallingDataFromTest(testClass, persistenceUnitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareMarshallingDataFromTest(Class<?> testClass, String persistenceUnitName) {
        String makeBaseDb = PersistenceUtil.getDatasourceProperties().getProperty("makeBaseDb");
        boolean baseDBCreationOngoing = false;
        if ("true".equals(makeBaseDb)) {
            baseDBCreationOngoing = true;
        }
        HashMap<String, Object> testContext = MarshallingDBUtil.initializeMarshalledDataEMF(persistenceUnitName, testClass, baseDBCreationOngoing);
        if (baseDBCreationOngoing) {
            MarshallingTestUtil.checkMarshalledSnapshots(testContext);
            return;
        }
        ArrayList<MarshalledData> testDataList = null;
        try {
            EntityManagerFactory testEMF = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
            testDataList = MarshallingTestUtil.retrieveMarshallingData(testEMF);
        }
        finally {
            PersistenceUtil.tearDown(testContext);
        }
        Assert.assertNotNull((String)("Not marshalled data found for " + testClass.getSimpleName()), (Object)(testDataList != null && !testDataList.isEmpty() ? 1 : 0));
        String[] baseDbVersions = MarshallingDBUtil.getListOfBaseDbVers(testClass);
        for (int v = 0; v < baseDbVersions.length; ++v) {
            logger.info("Loading marshalled data from base DB version: [" + baseDbVersions[v] + "]");
            HashMap<String, Object> baseContext = MarshallingDBUtil.initializeMarshalledDataEMF(persistenceUnitName, testClass, true, baseDbVersions[v]);
            ArrayList<MarshalledData> baseDataList = null;
            try {
                EntityManagerFactory baseEMF = (EntityManagerFactory)baseContext.get("drools.persistence.jpa.EntityManagerFactory");
                baseDataList = MarshallingTestUtil.retrieveMarshallingData(baseEMF);
            }
            finally {
                PersistenceUtil.tearDown(baseContext);
            }
            Assert.assertTrue((String)"No base marshalled data found", (baseDataList != null && !baseDataList.isEmpty() ? 1 : 0) != 0);
            MarshallingTestUtil.compareTestAndBaseMarshallingData(testClass, testDataList, baseDataList, baseDbVersions[v]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkMarshalledSnapshots(HashMap<String, Object> testContext) {
        logger.trace("Checking MarshalledData objects saved in base db.");
        ArrayList<MarshalledData> baseDataList = null;
        try {
            EntityManagerFactory testEMF = (EntityManagerFactory)testContext.get("drools.persistence.jpa.EntityManagerFactory");
            baseDataList = MarshallingTestUtil.retrieveMarshallingData(testEMF);
        }
        finally {
            PersistenceUtil.tearDown(testContext);
        }
        Assert.assertNotNull((String)"Could not rerieve list of MarshalledData from base db.", baseDataList);
        Assert.assertTrue((String)"List of MarshalledData from base db is empty.", (!baseDataList.isEmpty() ? 1 : 0) != 0);
        for (MarshalledData marshalledData : baseDataList) {
            try {
                logger.debug("Unmarshalling snapshot: " + marshalledData.getTestMethodAndSnapshotNum());
                MarshallingTestUtil.unmarshallObject(marshalledData);
            }
            catch (Exception e) {
                logger.error(e.getClass().getSimpleName() + " thrown while unmarshalling [" + marshalledData.getTestMethodAndSnapshotNum() + "] data stored in base database");
            }
        }
        logger.trace("MarshalledData objects saved in base db:");
        for (MarshalledData marshalledData : baseDataList) {
            logger.trace("- " + marshalledData);
        }
    }

    public static ArrayList<MarshalledData> retrieveMarshallingData(EntityManagerFactory emf) {
        ArrayList<MarshalledData> marshalledDataList = new ArrayList<MarshalledData>();
        BitronixTransactionManager txm = null;
        try {
            txm = TransactionManagerServices.getTransactionManager();
            txm.begin();
        }
        catch (Exception e) {
            logger.warn("Unable to retrieve marshalled snapshots from marshalling database.");
            e.printStackTrace();
            return marshalledDataList;
        }
        EntityManager em = emf.createEntityManager();
        List mdList = em.createQuery("SELECT m FROM MarshalledData m").getResultList();
        for (Object resultObject : mdList) {
            MarshalledData marshalledData = (MarshalledData)resultObject;
            if (StringUtils.isEmpty((CharSequence)marshalledData.testMethodName) || marshalledData.snapshotNumber == null) {
                Assert.fail((String)"MarshalledData object does not contain the proper identification information.");
            }
            marshalledDataList.add(marshalledData);
            logger.trace("> " + marshalledData);
        }
        try {
            txm.commit();
        }
        catch (Exception e) {
            logger.warn(e.getClass().getSimpleName() + " thrown when retrieving marshalled snapshots.");
            e.printStackTrace();
        }
        return marshalledDataList;
    }

    private static void compareTestAndBaseMarshallingData(Class<?> testClass, List<MarshalledData> testData, List<MarshalledData> baseData, String baseDbVersion) {
        HashMap<String, List<MarshalledData>> testSnapshotsPerTestMap = MarshallingTestUtil.extractSnapshotsPerTestMethodMap(testClass, testData);
        HashMap<String, List<MarshalledData>> baseSnapshotsPerTestMap = MarshallingTestUtil.extractSnapshotsPerTestMethodMap(testClass, baseData);
        MarshallingTestUtil.sanityCheckMarshalledData(testClass, testSnapshotsPerTestMap, baseSnapshotsPerTestMap);
        HashMap<String, MarshalledData> testMarshalledDataSnapshotMap = new HashMap<String, MarshalledData>();
        HashMap<String, MarshalledData> baseMarshalledDataSnapshotMap = new HashMap<String, MarshalledData>();
        for (String testMethod : testSnapshotsPerTestMap.keySet()) {
            for (MarshalledData testMarshalledData : testSnapshotsPerTestMap.get(testMethod)) {
                testMarshalledDataSnapshotMap.put(testMarshalledData.getTestMethodAndSnapshotNum(), testMarshalledData);
            }
        }
        for (String testMethod : baseSnapshotsPerTestMap.keySet()) {
            for (MarshalledData baseMarshalledData : baseSnapshotsPerTestMap.get(testMethod)) {
                baseMarshalledDataSnapshotMap.put(baseMarshalledData.getTestMethodAndSnapshotNum(), baseMarshalledData);
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (String testMethodVer : testMarshalledDataSnapshotMap.keySet()) {
            logger.info("Comparing marshalled info for " + testMethodVer);
            Object baseObject = null;
            MarshalledData baseMarshalledData = (MarshalledData)baseMarshalledDataSnapshotMap.get(testMethodVer);
            try {
                baseObject = MarshallingTestUtil.unmarshallObject(baseMarshalledData);
            }
            catch (Exception e) {
                logger.info("Unable to unmarshall " + baseDbVersion + " data [" + testMethodVer + "]: " + e.getClass().getSimpleName() + ": " + e.getMessage() + "]");
                continue;
            }
            Object testObject = null;
            MarshalledData testMarshalledData = (MarshalledData)testMarshalledDataSnapshotMap.get(testMethodVer);
            try {
                testObject = MarshallingTestUtil.unmarshallObject(testMarshalledData);
            }
            catch (Exception e) {
                Assert.fail((String)("Unable to unmarshall " + baseDbVersion + " data: [" + e.getClass().getSimpleName() + ": " + e.getMessage() + "]"));
            }
            Assert.assertNotNull((String)"Unmarshalled test data resulted in null object!", (Object)testObject);
            Assert.assertNotNull((String)"Unmarshalled base data resulted in null object!", (Object)baseObject);
            if (CompareViaReflectionUtil.compareInstances(baseObject, testObject)) continue;
            String errorMsg = "Unmarshalled " + baseObject.getClass().getSimpleName() + " object from " + baseDbVersion + " data is not equal to test unmarshalled object [" + baseMarshalledData.getTestMethodAndSnapshotNum() + "]";
            errors.add(errorMsg);
        }
        if (errors.size() > 0) {
            for (int i = errors.size() - 1; i > 0; --i) {
                logger.warn((String)errors.get(i));
            }
            Assert.fail((String)((String)errors.get(1)));
        }
    }

    private static HashMap<String, List<MarshalledData>> extractSnapshotsPerTestMethodMap(Class<?> testClass, List<MarshalledData> marshalledDataList) {
        String testClassName = testClass.getName();
        HashMap<String, List<MarshalledData>> snapshotsPerTestMethod = new HashMap<String, List<MarshalledData>>();
        for (MarshalledData marshalledData : marshalledDataList) {
            if (!marshalledData.testMethodName.startsWith(testClassName)) continue;
            List<MarshalledData> testMethodMarshalledDataList = snapshotsPerTestMethod.get(marshalledData.testMethodName);
            if (testMethodMarshalledDataList == null) {
                testMethodMarshalledDataList = new ArrayList<MarshalledData>();
                snapshotsPerTestMethod.put(marshalledData.testMethodName, testMethodMarshalledDataList);
            }
            testMethodMarshalledDataList.add(marshalledData);
        }
        return snapshotsPerTestMethod;
    }

    private static void sanityCheckMarshalledData(Class<?> testClass, HashMap<String, List<MarshalledData>> testSnapshotsPerTestMap, HashMap<String, List<MarshalledData>> baseSnapshotsPerTestMap) {
        HashSet<String> testTestMethods = new HashSet<String>(testSnapshotsPerTestMap.keySet());
        ArrayList<String> untestableTestMethods = new ArrayList<String>();
        for (String baseTestMethod : baseSnapshotsPerTestMap.keySet()) {
            if (!testTestMethods.contains(baseTestMethod)) {
                logger.error("Marshalled data snapshots for test " + baseTestMethod + " exist in the base db, but not in the test db generated by this test run!");
                untestableTestMethods.add(baseTestMethod);
                continue;
            }
            junit.framework.Assert.assertNotNull((String)("Empty list of marshalled data snapshots in base for " + baseTestMethod), baseSnapshotsPerTestMap.get(baseTestMethod));
            int numBaseSnapshotsForTestMethod = baseSnapshotsPerTestMap.get(baseTestMethod).size();
            int numTestSnapshotsForTestMethod = testSnapshotsPerTestMap.get(baseTestMethod).size();
            if (numBaseSnapshotsForTestMethod != numTestSnapshotsForTestMethod) {
                logger.error("Has test changed? Unequal number [" + baseSnapshotsPerTestMap.get(baseTestMethod).size() + "/" + testSnapshotsPerTestMap.get(baseTestMethod).size() + "] of for test " + baseTestMethod);
                if (testSnapshotsPerTestMap.remove(baseTestMethod) != null) {
                    logger.warn("Removing data and NOT comparing data for test " + baseTestMethod);
                    untestableTestMethods.add(baseTestMethod);
                }
            }
            testTestMethods.remove(baseTestMethod);
        }
        for (String badTestMethod : untestableTestMethods) {
            baseSnapshotsPerTestMap.remove(badTestMethod);
        }
        for (String testMethod : testTestMethods) {
            logger.info("Marshalled data snapshots for test " + testMethod + " do not exist in this base db.");
            testSnapshotsPerTestMap.keySet().remove(testMethod);
        }
    }

    public static Object unmarshallObject(MarshalledData marshalledData) throws Exception {
        if (SessionInfo.class.getName().equals(marshalledData.marshalledObjectClassName)) {
            return MarshallingTestUtil.unmarshallSession(marshalledData);
        }
        if (WorkItemInfo.class.getName().equals(marshalledData.marshalledObjectClassName)) {
            return MarshallingTestUtil.unmarshallWorkItem(marshalledData.byteArray);
        }
        if (PROCESS_INSTANCE_INFO_CLASS_NAME.equals(marshalledData.marshalledObjectClassName)) {
            return MarshallingTestUtil.unmarshallProcessInstance(marshalledData.byteArray);
        }
        throw new UnsupportedOperationException("Unable to unmarshall object of type \"" + marshalledData.marshalledObjectClassName + "\"");
    }

    protected static StatefulKnowledgeSession unmarshallSession(MarshalledData marshalledData) throws Exception {
        KnowledgeBase kbase = STORE_KNOWLEDGE_BASE ? (KnowledgeBase)DroolsStreamUtils.streamIn((byte[])marshalledData.serializedKnowledgeBase) : KnowledgeBaseFactory.newKnowledgeBase();
        ObjectMarshallingStrategy[] strategies = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        strategies = MarshallingTestUtil.addProcessInstanceResolverStrategyIfAvailable(strategies);
        Marshaller marshaller = MarshallerFactory.newMarshaller((KnowledgeBase)kbase, (ObjectMarshallingStrategy[])strategies);
        ByteArrayInputStream bais = new ByteArrayInputStream(marshalledData.byteArray);
        SessionConfiguration conf = SessionConfiguration.getDefaultInstance();
        Environment env = EnvironmentFactory.newEnvironment();
        StatefulKnowledgeSession ksession = marshaller.unmarshall((InputStream)bais, (KnowledgeSessionConfiguration)conf, env);
        return ksession;
    }

    private static WorkItem unmarshallWorkItem(byte[] marshalledSessionByteArray) throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        ByteArrayInputStream bais = new ByteArrayInputStream(marshalledSessionByteArray);
        MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, null, null, null, env);
        WorkItem unmarshalledWorkItem = InputMarshaller.readWorkItem((MarshallerReaderContext)context);
        context.close();
        return unmarshalledWorkItem;
    }

    private static Object unmarshallProcessInstance(byte[] marshalledSessionByteArray) throws Exception {
        Class<?> processInstanceMarshallerClass = Class.forName(PROCESS_INSTANCE_MARSHALL_UTIL_CLASS_NAME);
        Method unmarshallMethod = processInstanceMarshallerClass.getMethod("unmarshallProcessInstances", marshalledSessionByteArray.getClass());
        Object unmarshalledProcessInstance = unmarshallMethod.invoke(null, new Object[]{marshalledSessionByteArray});
        return unmarshalledProcessInstance;
    }

    protected static byte[] getProcessInstanceInfoByteArray(Object processInstanceInfo) {
        byte[] byteArray = null;
        Class<?> processInstanceInfoClass = processInstanceInfo.getClass();
        try {
            Method getByteArrayMethod = processInstanceInfoClass.getMethod("getProcessInstanceByteArray", null);
            Object byteArrayObject = getByteArrayMethod.invoke(processInstanceInfo, (Object[])null);
            byteArray = (byte[])byteArrayObject;
        }
        catch (Exception e) {
            Assert.fail((String)(e.getClass().getSimpleName() + ": unable to retrieve byte array from " + processInstanceInfoClass.getSimpleName()));
        }
        return byteArray;
    }

    protected static Long getProcessInstanceInfoId(Object obj) {
        Long id = null;
        try {
            Method getIdMethod = Class.forName(PROCESS_INSTANCE_INFO_CLASS_NAME).getMethod("getId", null);
            Object idObj = getIdMethod.invoke(obj, (Object[])null);
            id = (Long)idObj;
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to retrieve id of ProcessInstanceInfo: [" + e.getClass().getSimpleName() + "] " + e.getMessage()));
        }
        return id;
    }

    protected static byte[] getWorkItemByteArray(WorkItemInfo workItemInfo) {
        Method byteArrayMethod = null;
        byte[] byteArray = null;
        try {
            byteArrayMethod = WorkItemInfo.class.getMethod("getWorkItemByteArray", null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (byteArrayMethod != null) {
            byteArray = workItemInfo.getWorkItemByteArray();
        } else {
            try {
                Field byteArrayField = WorkItemInfo.class.getDeclaredField("workItemByteArray");
                byteArrayField.setAccessible(true);
                byteArray = (byte[])byteArrayField.get(workItemInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                junit.framework.Assert.fail((String)"Unable to retrieve byte array from WorkItemInfo object.");
            }
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byteArrayHashCode(byte[] byteArray) {
        StringBuilder hashCode = new StringBuilder();
        try {
            byte[] messageDigest;
            MessageDigest messageDigest2 = algorithm;
            synchronized (messageDigest2) {
                algorithm.reset();
                algorithm.update(byteArray);
                messageDigest = algorithm.digest();
            }
            for (int i = 0; i < messageDigest.length; ++i) {
                hashCode.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashCode.toString();
    }

    protected static String getTestMethodName() {
        StackTraceElement testMethodSTE;
        Class<?> steClass;
        int i;
        String testMethodName = null;
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        block0: for (i = 3; i < ste.length; ++i) {
            steClass = MarshallingTestUtil.getSTEClass(ste[i]);
            if (steClass == null) continue;
            Method[] classMethods = steClass.getMethods();
            String methodName = ste[i].getMethodName();
            for (int m = 0; m < classMethods.length; ++m) {
                if (!classMethods[m].getName().equals(methodName)) continue;
                Annotation[] annos = classMethods[m].getAnnotations();
                for (int a = 0; a < annos.length; ++a) {
                    if (!(annos[a] instanceof Test)) continue;
                    testMethodName = steClass.getName() + "." + methodName;
                    break block0;
                }
            }
        }
        for (i = 0; testMethodName == null && i < ste.length; ++i) {
            steClass = MarshallingTestUtil.getSTEClass(ste[i]);
            if (!"runTest".equals(ste[i].getMethodName())) continue;
            do {
                if (TestCase.class.equals(steClass)) {
                    testMethodSTE = ste[i - 5];
                    testMethodName = MarshallingTestUtil.getSTEClass(testMethodSTE).getName() + "." + testMethodSTE.getMethodName();
                }
                steClass = steClass.getSuperclass();
            } while (testMethodName == null && steClass != null);
        }
        if (testMethodName == null) {
            for (i = 0; testMethodName == null && i < ste.length; ++i) {
                steClass = MarshallingTestUtil.getSTEClass(ste[i]);
                if (!"call".equals(ste[i].getMethodName())) continue;
                while (true) {
                    if (!DefaultTimerJobInstance.class.equals(steClass)) {
                        continue;
                    }
                    testMethodSTE = ste[i - 5];
                    testMethodName = MarshallingTestUtil.getSTEClass(testMethodSTE).getName() + "." + testMethodSTE.getMethodName();
                }
            }
        }
        return testMethodName;
    }

    private static Class<?> getSTEClass(StackTraceElement ste) {
        Class<?> steClass = null;
        try {
            steClass = Class.forName(ste.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return steClass;
    }

    private static ObjectMarshallingStrategy[] addProcessInstanceResolverStrategyIfAvailable(ObjectMarshallingStrategy[] strategies) {
        ObjectMarshallingStrategy processInstanceResolverStrategyObject = null;
        try {
            Class<?> strategyClass = Class.forName(PROCESS_INSTANCE_RESOLVER_STRATEGY);
            Constructor<?> constructor = strategyClass.getConstructors()[0];
            processInstanceResolverStrategyObject = (ObjectMarshallingStrategy)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        ObjectMarshallingStrategy[] newStrategies = new ObjectMarshallingStrategy[strategies.length + 1];
        if (processInstanceResolverStrategyObject != null) {
            for (int i = 0; i < strategies.length; ++i) {
                newStrategies[i] = strategies[i];
            }
            newStrategies[strategies.length] = processInstanceResolverStrategyObject;
            strategies = newStrategies;
        }
        return strategies;
    }

    static {
        if (algorithm == null) {
            try {
                algorithm = MessageDigest.getInstance("SHA-1");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

