/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.util;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.base.MapGlobalResolver;
import org.drools.impl.EnvironmentFactory;
import org.drools.marshalling.util.EntityManagerFactoryProxy;
import org.drools.marshalling.util.MarshallingDBUtil;
import org.drools.marshalling.util.UserTransactionProxy;
import org.drools.runtime.Environment;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtil {
    private static Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    private static boolean TEST_MARSHALLING = true;
    public static final String DROOLS_PERSISTENCE_UNIT_NAME = "org.drools.persistence.jpa";
    public static final String JBPM_PERSISTENCE_UNIT_NAME = "org.jbpm.persistence.jpa";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static TestH2Server h2Server = new TestH2Server();
    private static Properties defaultProperties = null;
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, true);
    }

    public static HashMap<String, Object> setupWithPoolingDataSource(String persistenceUnitName, boolean testMarshalling) {
        EntityManagerFactory emf;
        Object testMarshallingProperty;
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        String jdbcUrl = dsProps.getProperty("url");
        String driverClass = dsProps.getProperty("driverClassName");
        if (!driverClass.startsWith("org.h2")) {
            TEST_MARSHALLING = false;
        }
        if ("true".equals(testMarshallingProperty = dsProps.get("testMarshalling"))) {
            TEST_MARSHALLING = true;
            if (!testMarshalling) {
                TEST_MARSHALLING = false;
            }
        } else {
            TEST_MARSHALLING = false;
        }
        if (TEST_MARSHALLING) {
            Class<?> testClass = null;
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            int i = 1;
            do {
                try {
                    testClass = Class.forName(ste[i++].getClassName());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            } while (PersistenceUtil.class.equals(testClass) && i < ste.length);
            Assert.assertNotNull((String)"Unable to resolve test class!", testClass);
            jdbcUrl = MarshallingDBUtil.initializeTestDb(dsProps, testClass);
        }
        PoolingDataSource ds1 = PersistenceUtil.setupPoolingDataSource(dsProps);
        if (driverClass.startsWith("org.h2")) {
            if (!TEST_MARSHALLING) {
                jdbcUrl = jdbcUrl + "tcp://localhost/JPADroolsFlow";
            }
            ds1.getDriverProperties().setProperty("url", jdbcUrl);
        }
        ds1.init();
        context.put(DATASOURCE, ds1);
        if (TEST_MARSHALLING) {
            Properties overrideProperties = new Properties();
            overrideProperties.setProperty("hibernate.connection.url", jdbcUrl);
            EntityManagerFactory realEmf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)overrideProperties);
            emf = (EntityManagerFactory)EntityManagerFactoryProxy.newInstance(realEmf);
            UserTransaction ut = (UserTransaction)UserTransactionProxy.newInstance(realEmf);
            context.put("drools.transaction.Transaction", ut);
        } else {
            emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        }
        context.put("drools.persistence.jpa.EntityManagerFactory", emf);
        return context;
    }

    public static void tearDown(HashMap<String, Object> context) {
        if (context != null) {
            Object ds1Object;
            Object emfObject;
            BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
            if (txm != null) {
                txm.shutdown();
            }
            if ((emfObject = context.remove("drools.persistence.jpa.EntityManagerFactory")) != null) {
                try {
                    EntityManagerFactory emf = (EntityManagerFactory)emfObject;
                    emf.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((ds1Object = context.remove(DATASOURCE)) != null) {
                try {
                    PoolingDataSource ds1 = (PoolingDataSource)ds1Object;
                    ds1.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static PoolingDataSource setupPoolingDataSource(Properties dsProps) {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/testDS1");
        pds.setClassName(dsProps.getProperty("className"));
        pds.setMaxPoolSize(Integer.parseInt(dsProps.getProperty("maxPoolSize")));
        pds.setAllowLocalTransactions(Boolean.parseBoolean(dsProps.getProperty("allowLocalTransactions")));
        for (String propertyName : new String[]{"user", "password"}) {
            pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
        }
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2")) {
            if (!TEST_MARSHALLING) {
                h2Server.start();
            }
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else {
            pds.setClassName(dsProps.getProperty("className"));
            if (driverClass.startsWith("oracle")) {
                pds.getDriverProperties().put("driverType", "thin");
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
            } else if (driverClass.startsWith("com.ibm.db2")) {
                pds.getDriverProperties().put("databaseName", dsProps.getProperty("databaseName"));
                pds.getDriverProperties().put("driverType", "4");
                pds.getDriverProperties().put("serverName", dsProps.getProperty("serverName"));
                pds.getDriverProperties().put("portNumber", dsProps.getProperty("portNumber"));
            } else if (driverClass.startsWith("com.microsoft")) {
                for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
                pds.getDriverProperties().put("selectMethod", "cursor");
                pds.getDriverProperties().put("InstanceName", "MSSQL01");
            } else if (driverClass.startsWith("com.mysql")) {
                for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else if (driverClass.startsWith("com.sybase")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("REQUEST_HA_SESSION", "false");
                pds.getDriverProperties().put("networkProtocol", "Tds");
            } else if (driverClass.startsWith("org.postgresql")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else {
                throw new RuntimeException("Unknown driver class: " + driverClass);
            }
        }
        return pds;
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/JPADroolsFlow", "sa", "", "org.h2.Driver", "bitronix.tm.resource.jdbc.lrc.LrcXADataSource", "16", "true"};
            Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String password;
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty("password")) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static boolean useTransactions() {
        boolean useTransactions = false;
        String databaseDriverClassName = PersistenceUtil.getDatasourceProperties().getProperty("driverClassName");
        if (databaseDriverClassName.startsWith("org.postgresql")) {
            useTransactions = true;
        }
        return useTransactions;
    }

    public static Object getValueOfField(String fieldname, Object source) {
        String sourceClassName = source.getClass().getSimpleName();
        Field field = null;
        try {
            field = source.getClass().getDeclaredField(fieldname);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Unable to retrieve " + fieldname + " field from " + sourceClassName + ": " + e.getCause()));
        }
        Assert.assertNotNull((String)("." + fieldname + " field is null!?!"), (Object)field);
        Object fieldValue = null;
        try {
            fieldValue = field.get(source);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Unable to retrieve value of " + fieldname + " from " + sourceClassName + ": " + e.getCause()));
        }
        return fieldValue;
    }

    public static Environment createEnvironment(HashMap<String, Object> context) {
        Environment env = EnvironmentFactory.newEnvironment();
        UserTransaction ut = (UserTransaction)context.get("drools.transaction.Transaction");
        if (ut != null) {
            env.set("drools.transaction.Transaction", (Object)ut);
        }
        env.set("drools.persistence.jpa.EntityManagerFactory", context.get("drools.persistence.jpa.EntityManagerFactory"));
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        return env;
    }

    private static class TestH2Server {
        private Server realH2Server;

        private TestH2Server() {
        }

        public void start() {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
                    this.realH2Server = Server.createTcpServer((String[])new String[0]);
                    this.realH2Server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
            super.finalize();
        }
    }
}

