/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Synchronization;
import javax.transaction.UserTransaction;
import org.drools.marshalling.util.EntityManagerFactoryProxy;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTransactionProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(UserTransactionProxy.class);
    private UserTransaction ut;
    private EntityManagerFactory emf;
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";

    public static Object newInstance(EntityManagerFactory emf) {
        UserTransaction ut = UserTransactionProxy.findUserTransaction();
        return Proxy.newProxyInstance(ut.getClass().getClassLoader(), EntityManagerFactoryProxy.getAllInterfaces(ut), (InvocationHandler)new UserTransactionProxy(ut, emf));
    }

    private static UserTransaction findUserTransaction() {
        try {
            InitialContext context = new InitialContext();
            return (UserTransaction)context.lookup(DEFAULT_USER_TRANSACTION_NAME);
        }
        catch (NamingException ex) {
            logger.debug("No UserTransaction found at JNDI location [{}]", (Object)DEFAULT_USER_TRANSACTION_NAME, (Object)ex);
            return null;
        }
    }

    private UserTransactionProxy(UserTransaction ut, EntityManagerFactory emf) {
        this.ut = ut;
        this.emf = emf;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        String methodName = method.getName();
        logger.trace(methodName);
        if ("commit".equals(methodName) && args == null) {
            BitronixTransaction bt = ((BitronixTransactionManager)this.ut).getCurrentTransaction();
            Iterator iter = bt.getSynchronizationScheduler().reverseIterator();
            while (iter.hasNext()) {
                Synchronization synchronization = (Synchronization)iter.next();
                try {
                    synchronization.beforeCompletion();
                }
                catch (RuntimeException ex) {
                    bt.setStatus(1);
                    throw ex;
                }
            }
            String testMethodName = MarshallingTestUtil.getTestMethodName();
            if (testMethodName != null) {
                EntityManager em = this.emf.createEntityManager();
                EntityManagerFactoryProxy.updateManagedObjects(testMethodName, em);
                em.close();
            }
            this.ut.commit();
            return result;
        }
        result = this.invoke(method, this.ut, args);
        return result;
    }

    private Object invoke(Method method, Object object, Object[] args) throws Throwable {
        Object result = null;
        try {
            result = method.invoke(object, args);
        }
        catch (InvocationTargetException ite) {
            logger.warn(method.getName() + " threw " + ite.getClass().getSimpleName() + ": " + ite.getMessage());
            throw ite;
        }
        return result;
    }
}

