/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import bitronix.tm.TransactionManagerServices;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.base.MapGlobalResolver;
import org.drools.command.Command;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.impl.EnvironmentFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.jta.JtaTransactionManagerTest;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTestCommand
implements GenericCommand<Void> {
    private static final long serialVersionUID = -7640078670024414748L;
    private Object mainObject;
    private Object subObject;
    private EntityManager em;
    private EntityManagerFactory emf;

    public TransactionTestCommand(Object mainObject, Object subObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = subObject;
        this.setPersistenceFields(env);
    }

    public TransactionTestCommand(Object mainObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = null;
        this.setPersistenceFields(env);
    }

    private void setPersistenceFields(HashMap<String, Object> env) {
        this.em = (EntityManager)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER);
        this.emf = (EntityManagerFactory)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY);
    }

    private HashMap<String, Object> getPersistenceEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER, this.em);
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY, this.emf);
        return env;
    }

    public Void execute(Context context) {
        this.em.joinTransaction();
        this.em.persist(this.mainObject);
        if (this.subObject != null) {
            StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
            KnowledgeBase cleanKBase = KnowledgeBaseFactory.newKnowledgeBase();
            cleanKBase.addKnowledgePackages(ksession.getKnowledgeBase().getKnowledgePackages());
            StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)cleanKBase, null, (Environment)this.initializeEnvironment());
            TransactionTestCommand transactionTestSubCommand = new TransactionTestCommand(this.subObject, this.getPersistenceEnvironment());
            commandKSession.execute((Command)transactionTestSubCommand);
        }
        return null;
    }

    private Environment initializeEnvironment() {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("drools.Globals", (Object)new MapGlobalResolver());
        env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }
}

