/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JpaPersistenceTraitTest {
    private HashMap<String, Object> context;
    private Environment env;

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    @Test
    public void testTraitsWithJPA() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \ndeclare TBean \n  @Traitable \n  fld : String \nend \n declare trait Mask \n  fld : String \n  xyz : int  \nend \n\n declare trait Cloak \n  fld : String \n  ijk : String  \nend \nrule Init \nwhen \nthen \n  insert( new TBean(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  Mask m = don( $b, Mask.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\nrule Don2 \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  Cloak c = don( $b, Cloak.class ); \n  modify (c) { setIjk( \"ijklmn\" ); } \n  list.add( c ); \n  System.out.println( \"Don result : \" + c ); \n end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        int id = ksession.getId();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection x = ksession2.getObjects();
        Assert.assertEquals((long)4L, (long)x.size());
        TraitableBean core = null;
        for (Object o : x) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)2L, (long)core.getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.factmodel.traits.Thing"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Cloak"));
    }

    @Test
    public void testMapBasedTraitsWithJPA() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \ndeclare TBean2 \n  @Traitable \n  fld : String \nend \n declare trait Mask2 \n  fld : String \n  xyz : int  \nend \n\n declare trait Cloak2 \n  fld : String \n  ijk : String  \nend \nrule Init \nwhen \nthen \n  insert( new TBean2(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean2( ) \nthen \n  Mask2 m = don( $b, Mask2.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\nrule Don2 \nno-loop \nwhen \n  $b : TBean2( ) \nthen \n  Cloak2 c = don( $b, Cloak2.class ); \n  modify (c) { setIjk( \"ijklmn\" ); } \n  list.add( c ); \n  System.out.println( \"Don result : \" + c ); \n end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactory.setMode((TraitFactory.VirtualPropertyMode)TraitFactory.VirtualPropertyMode.MAP, (KnowledgeBase)kbase);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        int id = ksession.getId();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection x = ksession2.getObjects();
        Assert.assertEquals((long)4L, (long)x.size());
        TraitableBean core = null;
        for (Object o : x) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)2L, (long)core.getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.factmodel.traits.Thing"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask2"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Cloak2"));
    }

    @Test
    public void testTraitsLegacyWrapperWithJPA() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \ndeclare TBean \n  fld : String \nend \n declare trait Mask \n  fld : String \n  xyz : int  \nend \n\n rule Init \nwhen \nthen \n  insert( new TBean(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  System.out.println( \"Din Don Dan: \"  ); \n   Mask m = don( $b, Mask.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        int id = ksession.getId();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection y = ksession2.getObjects();
        Assert.assertEquals((long)3L, (long)y.size());
        TraitableBean core = null;
        for (Object o : y) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)1L, (long)core.getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.factmodel.traits.Thing"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask"));
    }
}

