/*
 * Decompiled with CFR 0.152.
 */
package org.drools.timer.integrationtests;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManagerFactory;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.type.FactType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.persistence.util.PersistenceUtil;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.time.SessionPseudoClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerAndCalendarTest {
    private PoolingDataSource ds1;
    private EntityManagerFactory emf;
    private HashMap<String, Object> context;

    @Test
    public void testTimerRuleAfterIntReloadSession() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (int:1000 500) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        Assert.assertEquals((long)0L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1700L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testTimerRuleAfterCronReloadSession() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (cron: * * * * * ?) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        ksession.setGlobal("list", list);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(2L, TimeUnit.SECONDS);
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testEventExpires() throws Exception {
        String timerRule = "package org.drools.test\ndeclare TestEvent \n    @role( event )\n    @expires( 10s )\nend\nrule TimerRule \n    when \n        TestEvent( ) from entry-point \"Test\"\n    then \nend";
        KnowledgeBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbconf);
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        StatefulKnowledgeSession ksession = this.createSession(kbase);
        FactType type = kbase.getFactType("org.drools.test", "TestEvent");
        Assert.assertNotNull((String)"could not get type", (Object)type);
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession.getWorkingMemoryEntryPoint("Test").insert(type.newInstance());
        ksession.fireAllRules();
        ksession = this.disposeAndReloadSession(ksession, kbase);
        ksession = this.disposeAndReloadSession(ksession, kbase);
    }

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.emf = (EntityManagerFactory)this.context.get("drools.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void after() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    private StatefulKnowledgeSession createSession(KnowledgeBase kbase) {
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, (KnowledgeSessionConfiguration)conf, (Environment)PersistenceUtil.createEnvironment(this.context));
        return ksession;
    }

    private StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KnowledgeBase kbase) {
        int ksessionId = ksession.getId();
        ksession.dispose();
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession newksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KnowledgeBase)kbase, (KnowledgeSessionConfiguration)conf, (Environment)PersistenceUtil.createEnvironment(this.context));
        return newksession;
    }

    private Collection<KnowledgePackage> buildKnowledgePackage(Resource resource, ResourceType resourceType) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, resourceType);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println("Error: " + error.getMessage());
            }
            Assert.fail((String)"KnowledgeBase did not build");
        }
        Collection packages = kbuilder.getKnowledgePackages();
        return packages;
    }
}

