/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jta;

import bitronix.tm.TransactionManagerServices;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.jta.JtaTransactionManagerTest;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.command.Context;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TransactionTestCommand
implements GenericCommand<Void> {
    private static final long serialVersionUID = -7640078670024414748L;
    private Object mainObject;
    private Object subObject;
    private EntityManager em;
    private EntityManagerFactory emf;

    public TransactionTestCommand(Object mainObject, Object subObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = subObject;
        this.setPersistenceFields(env);
    }

    public TransactionTestCommand(Object mainObject, HashMap<String, Object> env) {
        this.mainObject = mainObject;
        this.subObject = null;
        this.setPersistenceFields(env);
    }

    private void setPersistenceFields(HashMap<String, Object> env) {
        this.em = (EntityManager)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER);
        this.emf = (EntityManagerFactory)env.get(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY);
    }

    private HashMap<String, Object> getPersistenceEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER, this.em);
        env.put(JtaTransactionManagerTest.COMMAND_ENTITY_MANAGER_FACTORY, this.emf);
        return env;
    }

    public Void execute(Context context) {
        this.em.joinTransaction();
        this.em.persist(this.mainObject);
        if (this.subObject != null) {
            KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
            KnowledgeBase cleanKBase = KnowledgeBaseFactory.newKnowledgeBase();
            cleanKBase.addKnowledgePackages(((KnowledgeBase)ksession.getKieBase()).getKnowledgePackages());
            StatefulKnowledgeSession commandKSession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)cleanKBase, null, (Environment)this.initializeEnvironment());
            TransactionTestCommand transactionTestSubCommand = new TransactionTestCommand(this.subObject, this.getPersistenceEnvironment());
            commandKSession.execute((Command)transactionTestSubCommand);
        }
        return null;
    }

    private Environment initializeEnvironment() {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }
}

